/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.function.Consumer;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.support.StateMachineReactiveLifecycle;
import org.springframework.statemachine.transition.Transition;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public interface StateMachineExecutor<S, E>
extends StateMachineReactiveLifecycle {
    public Mono<Void> queueEvent(Mono<Message<E>> var1, StateMachineExecutorCallback var2);

    public void queueDeferredEvent(Message<E> var1);

    public Mono<Void> executeTriggerlessTransitions(StateContext<S, E> var1, State<S, E> var2);

    public void setInitialEnabled(boolean var1);

    public void setForwardedInitialEvent(Message<E> var1);

    public void setStateMachineExecutorTransit(StateMachineExecutorTransit<S, E> var1);

    public void addStateMachineInterceptor(StateMachineInterceptor<S, E> var1);

    public static class ExecutorExceptionHolder {
        private Throwable error;

        public void setError(Throwable error) {
            this.error = error;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public static class MonoSinkStateMachineExecutorCallback
    implements Consumer<MonoSink<Void>>,
    StateMachineExecutorCallback {
        private boolean complete;
        private Throwable error;

        @Override
        public void complete() {
            this.complete = true;
        }

        @Override
        public void error(Throwable e) {
            this.error = e;
        }

        @Override
        public void accept(MonoSink<Void> t) {
            if (this.complete) {
                t.success();
            } else if (this.error != null) {
                t.error(this.error);
            } else {
                t.success();
            }
        }
    }

    public static interface StateMachineExecutorCallback {
        public void complete();

        public void error(Throwable var1);
    }

    public static interface StateMachineExecutorTransit<S, E> {
        public Mono<Void> transit(Transition<S, E> var1, StateContext<S, E> var2, Message<E> var3);
    }
}

