/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.statemachine.support.ReactiveLifecycleManager;
import org.springframework.statemachine.support.StateMachineReactiveLifecycle;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class LifecycleObjectSupport
implements InitializingBean,
DisposableBean,
SmartLifecycle,
BeanFactoryAware,
StateMachineReactiveLifecycle {
    private static final Log log = LogFactory.getLog(LifecycleObjectSupport.class);
    private volatile boolean autoStartup = false;
    private volatile int phase = 0;
    private volatile BeanFactory beanFactory;
    private final AtomicBoolean afterPropertiesSetCalled = new AtomicBoolean(false);
    private final ReactiveLifecycleManager reactiveLifecycleManager = new ReactiveLifecycleManager(() -> this.doPreStartReactively(), () -> this.doPreStopReactively(), () -> this.doPostStartReactively(), () -> this.doPostStopReactively());

    public LifecycleObjectSupport() {
        this.reactiveLifecycleManager.setOwner(this);
    }

    public final void afterPropertiesSet() {
        try {
            if (this.afterPropertiesSetCalled.compareAndSet(false, true)) {
                this.onInit();
            } else {
                log.debug((Object)"afterPropertiesSet() is already called, not calling onInit()");
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BeanInitializationException("failed to initialize", (Throwable)e);
        }
    }

    public final void destroy() throws Exception {
        log.info((Object)"destroy called");
        this.doDestroy();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting bean factory: " + beanFactory + " for " + this));
        }
        this.beanFactory = beanFactory;
    }

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    public final int getPhase() {
        return this.phase;
    }

    public void start() {
        this.startReactively().block();
    }

    public void stop() {
        this.stopReactively().block();
    }

    @Override
    public Mono<Void> startReactively() {
        log.debug((Object)("startReactively " + this + " with rlm " + this.reactiveLifecycleManager));
        return this.reactiveLifecycleManager.startReactively();
    }

    @Override
    public Mono<Void> stopReactively() {
        log.debug((Object)("stopReactively " + this + " with rlm " + this.reactiveLifecycleManager));
        return this.reactiveLifecycleManager.stopReactively();
    }

    public boolean isRunning() {
        return this.reactiveLifecycleManager.isRunning();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected void onInit() throws Exception {
    }

    protected void doDestroy() {
    }

    protected Mono<Void> doPreStartReactively() {
        return Mono.empty();
    }

    protected Mono<Void> doPreStopReactively() {
        return Mono.empty();
    }

    protected Mono<Void> doPostStartReactively() {
        return Mono.empty();
    }

    protected Mono<Void> doPostStopReactively() {
        return Mono.empty();
    }
}

