/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.StateMachineContext;

public class DefaultStateMachineContext<S, E>
implements StateMachineContext<S, E> {
    private final String id;
    private final List<StateMachineContext<S, E>> childs;
    private final List<String> childRefs;
    private final S state;
    private final Map<S, S> historyStates;
    private final E event;
    private final Map<String, Object> eventHeaders;
    private final ExtendedState extendedState;

    public DefaultStateMachineContext(S state, E event, Map<String, Object> eventHeaders, ExtendedState extendedState) {
        this(new ArrayList<StateMachineContext<S, E>>(), state, event, eventHeaders, extendedState);
    }

    public DefaultStateMachineContext(S state, E event, Map<String, Object> eventHeaders, ExtendedState extendedState, Map<S, S> historyStates) {
        this(new ArrayList<StateMachineContext<S, E>>(), state, event, eventHeaders, extendedState, historyStates);
    }

    public DefaultStateMachineContext(S state, E event, Map<String, Object> eventHeaders, ExtendedState extendedState, Map<S, S> historyStates, String id) {
        this(new ArrayList<StateMachineContext<S, E>>(), state, event, eventHeaders, extendedState, historyStates, id);
    }

    public DefaultStateMachineContext(List<StateMachineContext<S, E>> childs, S state, E event, Map<String, Object> eventHeaders, ExtendedState extendedState) {
        this(childs, state, event, eventHeaders, extendedState, null);
    }

    public DefaultStateMachineContext(List<StateMachineContext<S, E>> childs, S state, E event, Map<String, Object> eventHeaders, ExtendedState extendedState, Map<S, S> historyStates) {
        this(childs, state, event, eventHeaders, extendedState, historyStates, null);
    }

    public DefaultStateMachineContext(List<StateMachineContext<S, E>> childs, S state, E event, Map<String, Object> eventHeaders, ExtendedState extendedState, Map<S, S> historyStates, String id) {
        this.childs = childs;
        this.childRefs = new ArrayList<String>();
        this.state = state;
        this.event = event;
        this.eventHeaders = eventHeaders;
        this.extendedState = extendedState;
        this.historyStates = historyStates != null ? historyStates : new HashMap();
        this.id = id;
    }

    public DefaultStateMachineContext(List<String> childRefs, List<StateMachineContext<S, E>> childs, S state, E event, Map<String, Object> eventHeaders, ExtendedState extendedState, Map<S, S> historyStates, String id) {
        this.childs = childs;
        this.childRefs = childRefs;
        this.state = state;
        this.event = event;
        this.eventHeaders = eventHeaders;
        this.extendedState = extendedState;
        this.historyStates = historyStates != null ? historyStates : new HashMap();
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<StateMachineContext<S, E>> getChilds() {
        return this.childs;
    }

    @Override
    public List<String> getChildReferences() {
        return this.childRefs;
    }

    @Override
    public S getState() {
        return this.state;
    }

    @Override
    public Map<S, S> getHistoryStates() {
        return this.historyStates;
    }

    @Override
    public E getEvent() {
        return this.event;
    }

    @Override
    public Map<String, Object> getEventHeaders() {
        return this.eventHeaders;
    }

    @Override
    public ExtendedState getExtendedState() {
        return this.extendedState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childRefs == null ? 0 : this.childRefs.hashCode());
        result = 31 * result + (this.childs == null ? 0 : this.childs.hashCode());
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 31 * result + (this.eventHeaders == null ? 0 : this.eventHeaders.hashCode());
        result = 31 * result + (this.extendedState == null ? 0 : this.extendedState.hashCode());
        result = 31 * result + (this.historyStates == null ? 0 : this.historyStates.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultStateMachineContext other = (DefaultStateMachineContext)obj;
        if (this.childRefs == null ? other.childRefs != null : !this.childRefs.equals(other.childRefs)) {
            return false;
        }
        if (this.childs == null ? other.childs != null : !this.childs.equals(other.childs)) {
            return false;
        }
        if (this.event == null ? other.event != null : !this.event.equals(other.event)) {
            return false;
        }
        if (this.eventHeaders == null ? other.eventHeaders != null : !this.eventHeaders.equals(other.eventHeaders)) {
            return false;
        }
        if (this.extendedState == null ? other.extendedState != null : !this.extendedState.equals(other.extendedState)) {
            return false;
        }
        if (this.historyStates == null ? other.historyStates != null : !this.historyStates.equals(other.historyStates)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    public String toString() {
        return "DefaultStateMachineContext [id=" + this.id + ", childs=" + this.childs + ", childRefs=" + this.childRefs + ", state=" + this.state + ", historyStates=" + this.historyStates + ", event=" + this.event + ", eventHeaders=" + this.eventHeaders + ", extendedState=" + this.extendedState + "]";
    }
}

