/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachineEventResult;
import org.springframework.statemachine.access.StateMachineAccess;
import org.springframework.statemachine.access.StateMachineAccessor;
import org.springframework.statemachine.action.ActionListener;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.monitor.StateMachineMonitor;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.AbstractState;
import org.springframework.statemachine.state.ForkPseudoState;
import org.springframework.statemachine.state.HistoryPseudoState;
import org.springframework.statemachine.state.JoinPseudoState;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.PseudoStateContext;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.PseudoStateListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateListenerAdapter;
import org.springframework.statemachine.support.DefaultExtendedState;
import org.springframework.statemachine.support.DefaultStateContext;
import org.springframework.statemachine.support.ReactiveStateMachineExecutor;
import org.springframework.statemachine.support.StateMachineExecutor;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.support.StateMachineObjectSupport;
import org.springframework.statemachine.support.StateMachineReactiveLifecycle;
import org.springframework.statemachine.support.StateMachineUtils;
import org.springframework.statemachine.transition.InitialTransition;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionConflictPolicy;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.statemachine.trigger.DefaultTriggerContext;
import org.springframework.statemachine.trigger.Trigger;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractStateMachine<S, E>
extends StateMachineObjectSupport<S, E>
implements StateMachine<S, E>,
StateMachineAccess<S, E> {
    private static final Log log = LogFactory.getLog(AbstractStateMachine.class);
    private final Collection<State<S, E>> states;
    private final Collection<Transition<S, E>> transitions;
    private final State<S, E> initialState;
    private final Transition<S, E> initialTransition;
    private final Message<E> initialEvent;
    private ExtendedState extendedState;
    private TransitionConflictPolicy transitionConflictPolicy;
    private volatile State<S, E> currentState;
    private volatile State<S, E> lastState;
    private volatile Exception currentError;
    private volatile PseudoState<S, E> history;
    private final Map<Trigger<S, E>, Transition<S, E>> triggerToTransitionMap = new HashMap<Trigger<S, E>, Transition<S, E>>();
    private final List<Transition<S, E>> triggerlessTransitions = new ArrayList<Transition<S, E>>();
    private StateMachine<S, E> relay;
    private StateMachineExecutor<S, E> stateMachineExecutor;
    private Boolean initialEnabled = null;
    private final UUID uuid;
    private String id;
    private volatile Message<E> forwardedInitialEvent;
    private StateMachine<S, E> parentMachine;

    public AbstractStateMachine(Collection<State<S, E>> states, Collection<Transition<S, E>> transitions, State<S, E> initialState) {
        this(states, transitions, initialState, new DefaultExtendedState());
    }

    public AbstractStateMachine(Collection<State<S, E>> states, Collection<Transition<S, E>> transitions, State<S, E> initialState, ExtendedState extendedState) {
        this(states, transitions, initialState, null, null, extendedState, null);
    }

    public AbstractStateMachine(Collection<State<S, E>> states, Collection<Transition<S, E>> transitions, State<S, E> initialState, Transition<S, E> initialTransition, Message<E> initialEvent, ExtendedState extendedState, UUID uuid) {
        this.uuid = uuid == null ? UUID.randomUUID() : uuid;
        this.states = states;
        this.transitions = transitions;
        this.initialState = initialState;
        this.initialEvent = initialEvent;
        this.extendedState = extendedState != null ? extendedState : new DefaultExtendedState();
        this.initialTransition = initialTransition == null ? new InitialTransition<S, E>(initialState) : initialTransition;
    }

    @Override
    public State<S, E> getState() {
        State<S, E> s = this.lastState;
        if (s != null && this.isComplete()) {
            return s;
        }
        return this.currentState;
    }

    @Override
    public State<S, E> getInitialState() {
        return this.initialState;
    }

    @Override
    public ExtendedState getExtendedState() {
        return this.extendedState;
    }

    public void setHistoryState(PseudoState<S, E> history) {
        this.history = history;
    }

    public PseudoState<S, E> getHistoryState() {
        return this.history;
    }

    @Override
    public boolean sendEvent(Message<E> event) {
        return (Boolean)this.sendEvent(Mono.just(event)).switchIfEmpty((Publisher)Flux.just(StateMachineEventResult.from(this, event, StateMachineEventResult.ResultType.DENIED))).reduce((Object)false, (a, r) -> !(a | r.getResultType() == StateMachineEventResult.ResultType.DENIED)).block();
    }

    @Override
    protected void notifyEventNotAccepted(StateContext<S, E> stateContext) {
        if (this.parentMachine == null) {
            super.notifyEventNotAccepted(stateContext);
        }
    }

    @Override
    public boolean sendEvent(E event) {
        return this.sendEvent((E)MessageBuilder.withPayload(event).build());
    }

    @Override
    public Flux<StateMachineEventResult<S, E>> sendEvents(Flux<Message<E>> events) {
        return events.flatMap(e -> this.handleEvent((Message<E>)e));
    }

    @Override
    public Flux<StateMachineEventResult<S, E>> sendEvent(Mono<Message<E>> event) {
        return event.flatMapMany(e -> this.handleEvent((Message<E>)e));
    }

    @Override
    public Mono<List<StateMachineEventResult<S, E>>> sendEventCollect(Mono<Message<E>> event) {
        return event.flatMapMany(e -> this.handleEvent((Message<E>)e)).collectList();
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        Assert.notNull(this.initialState, (String)"Initial state must be set");
        Assert.state((this.initialState.getPseudoState() != null && this.initialState.getPseudoState().getKind() == PseudoStateKind.INITIAL ? 1 : 0) != 0, (String)"Initial state's pseudostate kind must be INITIAL");
        this.lastState = null;
        this.extendedState.setExtendedStateChangeListener(new ExtendedState.ExtendedStateChangeListener(){

            @Override
            public void changed(Object key, Object value) {
                AbstractStateMachine.this.notifyExtendedStateChanged(key, value, AbstractStateMachine.this.buildStateContext(StateContext.Stage.EXTENDED_STATE_CHANGED, null, null, AbstractStateMachine.this.getRelayStateMachine()));
            }
        });
        for (Transition<S, E> transition : this.transitions) {
            Trigger<S, E> trigger = transition.getTrigger();
            if (trigger != null) {
                this.triggerToTransitionMap.put(trigger, transition);
                continue;
            }
            this.triggerlessTransitions.add(transition);
        }
        for (final State state : this.states) {
            state.addStateListener(new StateListenerAdapter<S, E>(){

                @Override
                public Mono<Void> doOnComplete(StateContext<S, E> context) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("State onComplete: state=[" + state + "] context=[" + context + "]"));
                    }
                    return ((AbstractStateMachine)AbstractStateMachine.this.getRelayStateMachine()).executeTriggerlessTransitions(AbstractStateMachine.this, context, state);
                }
            });
            if (state.isSubmachineState()) {
                StateMachine stateMachine = ((AbstractState)state).getSubmachine();
                stateMachine.addStateListener(new StateMachineObjectSupport.StateMachineListenerRelay(this));
            } else if (state.isOrthogonal()) {
                Collection collection = ((AbstractState)state).getRegions();
                for (Region region : collection) {
                    region.addStateListener(new StateMachineObjectSupport.StateMachineListenerRelay(this));
                }
            }
            if (state.getPseudoState() == null || state.getPseudoState().getKind() != PseudoStateKind.HISTORY_DEEP && state.getPseudoState().getKind() != PseudoStateKind.HISTORY_DEEP) continue;
            this.history = state.getPseudoState();
        }
        ReactiveStateMachineExecutor<S, E> executor = new ReactiveStateMachineExecutor<S, E>(this, this.getRelayStateMachine(), this.transitions, this.triggerToTransitionMap, this.triggerlessTransitions, this.initialTransition, this.initialEvent, this.transitionConflictPolicy);
        if (this.getBeanFactory() != null) {
            executor.setBeanFactory(this.getBeanFactory());
        }
        executor.afterPropertiesSet();
        executor.setStateMachineExecutorTransit(new StateMachineExecutor.StateMachineExecutorTransit<S, E>(){

            @Override
            public Mono<Void> transit(Transition<S, E> t, StateContext<S, E> ctx, Message<E> message) {
                return Mono.fromSupplier(() -> System.currentTimeMillis()).doOnNext(now -> AbstractStateMachine.this.notifyTransitionStart(AbstractStateMachine.this.buildStateContext(StateContext.Stage.TRANSITION_START, message, t, AbstractStateMachine.this.getRelayStateMachine()))).flatMap(now -> t.executeTransitionActions(ctx).then(Mono.just((Object)now))).doOnNext(now -> AbstractStateMachine.this.notifyTransition(AbstractStateMachine.this.buildStateContext(StateContext.Stage.TRANSITION, message, t, AbstractStateMachine.this.getRelayStateMachine()))).flatMap(now -> {
                    Object ret = null;
                    if (t.getTarget().getPseudoState() != null && t.getTarget().getPseudoState().getKind() == PseudoStateKind.JOIN) {
                        ret = AbstractStateMachine.this.exitFromState(t.getSource(), message, t, AbstractStateMachine.this.getRelayStateMachine());
                    } else if (t.getKind() == TransitionKind.INITIAL) {
                        Mono notify = Mono.fromRunnable(() -> AbstractStateMachine.this.notifyStateMachineStarted(AbstractStateMachine.this.buildStateContext(StateContext.Stage.STATEMACHINE_START, message, t, AbstractStateMachine.this.getRelayStateMachine())));
                        ret = AbstractStateMachine.this.switchToState(t.getTarget(), message, t, AbstractStateMachine.this.getRelayStateMachine()).then(notify);
                    } else {
                        ret = t.getKind() != TransitionKind.INTERNAL ? AbstractStateMachine.this.switchToState(t.getTarget(), message, t, AbstractStateMachine.this.getRelayStateMachine()) : Mono.empty();
                    }
                    return ret.then(Mono.just((Object)now));
                }).doOnNext(now -> {
                    AbstractStateMachine.this.notifyTransitionEnd(AbstractStateMachine.this.buildStateContext(StateContext.Stage.TRANSITION_END, message, t, AbstractStateMachine.this.getRelayStateMachine()));
                    AbstractStateMachine.this.notifyTransitionMonitor(AbstractStateMachine.this.getRelayStateMachine(), t, System.currentTimeMillis() - now);
                }).then();
            }
        });
        this.stateMachineExecutor = executor;
        for (Transition<S, E> transition : this.getTransitions()) {
            transition.addActionListener(new ActionListener<S, E>(){

                @Override
                public void onExecute(StateMachine<S, E> stateMachine, Function<StateContext<S, E>, Mono<Void>> action, long duration) {
                    AbstractStateMachine.this.notifyActionMonitor(stateMachine, action, duration);
                }
            });
        }
        for (State<S, E> state : this.getStates()) {
            state.addActionListener(new ActionListener<S, E>(){

                @Override
                public void onExecute(StateMachine<S, E> stateMachine, Function<StateContext<S, E>, Mono<Void>> action, long duration) {
                    AbstractStateMachine.this.notifyActionMonitor(stateMachine, action, duration);
                }
            });
        }
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.getBeanFactory() == null) {
            super.setBeanFactory(beanFactory);
            if (this.stateMachineExecutor instanceof BeanFactoryAware) {
                ((BeanFactoryAware)this.stateMachineExecutor).setBeanFactory(beanFactory);
            }
        }
    }

    @Override
    protected Mono<Void> doPreStartReactively() {
        return Mono.defer(() -> {
            if (this.currentState != null) {
                return Mono.fromRunnable(() -> {
                    super.doStart();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"State already set, disabling initial");
                    }
                    this.registerPseudoStateListener();
                    this.stateMachineExecutor.setInitialEnabled(false);
                }).and(this.stateMachineExecutor.startReactively()).doOnSuccess(x -> {
                    StateContext<S, E> stateContext = this.buildStateContext(StateContext.Stage.STATEMACHINE_START, null, null, this.getRelayStateMachine());
                    this.notifyStateMachineStarted(stateContext);
                }).and((Publisher)Mono.defer(() -> {
                    if (this.currentState != null && this.currentState.isSubmachineState()) {
                        StateMachine submachine = ((AbstractState)this.currentState).getSubmachine();
                        return submachine.startReactively();
                    }
                    if (this.currentState != null && this.currentState.isOrthogonal()) {
                        Collection regions = ((AbstractState)this.currentState).getRegions();
                        return Flux.fromIterable(regions).flatMap(r -> r.startReactively()).then();
                    }
                    return Mono.empty();
                }));
            }
            return Mono.fromRunnable(() -> {
                super.doStart();
                this.registerPseudoStateListener();
                if (this.initialEnabled != null && !this.initialEnabled.booleanValue()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Initial disable asked, disabling initial");
                    }
                    this.stateMachineExecutor.setInitialEnabled(false);
                } else {
                    this.stateMachineExecutor.setForwardedInitialEvent(this.forwardedInitialEvent);
                }
            }).and(this.stateMachineExecutor.startReactively());
        });
    }

    @Override
    protected Mono<Void> doPostStartReactively() {
        return this.isComplete() ? this.stopReactively() : super.doPostStartReactively();
    }

    @Override
    protected Mono<Void> doPreStopReactively() {
        return Mono.fromRunnable(() -> {
            this.notifyStateMachineStopped(this.buildStateContext(StateContext.Stage.STATEMACHINE_STOP, null, null, this));
            this.lastState = this.currentState;
            this.currentState = null;
            this.initialEnabled = null;
            log.debug((Object)("Stop complete " + this));
        }).then(this.stateMachineExecutor.stopReactively());
    }

    @Override
    protected void doDestroy() {
        this.stop();
    }

    @Override
    public void setStateMachineError(Exception exception) {
        this.currentError = exception == null ? null : (exception = this.getStateMachineInterceptors().stateMachineError(this, exception));
        if (this.currentError != null) {
            this.notifyStateMachineError(this.buildStateContext(StateContext.Stage.STATEMACHINE_ERROR, null, null, this, this.currentError));
        }
    }

    @Override
    public boolean hasStateMachineError() {
        return this.currentError != null;
    }

    @Override
    public void addStateListener(StateMachineListener<S, E> listener) {
        this.getStateListener().register(listener);
    }

    @Override
    public void removeStateListener(StateMachineListener<S, E> listener) {
        this.getStateListener().unregister(listener);
    }

    @Override
    public boolean isComplete() {
        State<S, E> s = this.currentState;
        if (s == null) {
            return !this.isRunning();
        }
        return s != null && s.getPseudoState() != null && s.getPseudoState().getKind() == PseudoStateKind.END;
    }

    @Override
    public Collection<State<S, E>> getStates() {
        return Collections.unmodifiableCollection(this.states);
    }

    @Override
    public Collection<Transition<S, E>> getTransitions() {
        return this.transitions;
    }

    @Override
    public void setInitialEnabled(boolean enabled) {
        this.initialEnabled = enabled;
    }

    @Override
    public StateMachineAccessor<S, E> getStateMachineAccessor() {
        return new StateMachineAccessor<S, E>(){

            @Override
            public void doWithAllRegions(Consumer<StateMachineAccess<S, E>> stateMachineAccess) {
                stateMachineAccess.accept(AbstractStateMachine.this);
                for (State state : AbstractStateMachine.this.states) {
                    if (state.isSubmachineState()) {
                        StateMachine submachine = ((AbstractState)state).getSubmachine();
                        submachine.getStateMachineAccessor().doWithAllRegions(stateMachineAccess);
                        continue;
                    }
                    if (!state.isOrthogonal()) continue;
                    Collection regions = ((AbstractState)state).getRegions();
                    for (Region region : regions) {
                        ((StateMachine)region).getStateMachineAccessor().doWithAllRegions(stateMachineAccess);
                    }
                }
            }

            @Override
            public List<StateMachineAccess<S, E>> withAllRegions() {
                ArrayList list = new ArrayList();
                list.add(AbstractStateMachine.this);
                for (State state : AbstractStateMachine.this.states) {
                    if (state.isSubmachineState()) {
                        StateMachine submachine = ((AbstractState)state).getSubmachine();
                        if (!(submachine instanceof StateMachineAccess)) continue;
                        list.add((StateMachineAccess)((Object)submachine));
                        continue;
                    }
                    if (!state.isOrthogonal()) continue;
                    Collection regions = ((AbstractState)state).getRegions();
                    for (Region region : regions) {
                        list.add((StateMachineAccess)((Object)region));
                    }
                }
                return list;
            }

            @Override
            public void doWithRegion(Consumer<StateMachineAccess<S, E>> stateMachineAccess) {
                stateMachineAccess.accept(AbstractStateMachine.this);
            }

            @Override
            public StateMachineAccess<S, E> withRegion() {
                return AbstractStateMachine.this;
            }
        };
    }

    @Override
    public void setRelay(StateMachine<S, E> stateMachine) {
        this.relay = stateMachine;
    }

    @Override
    public void setParentMachine(StateMachine<S, E> parentMachine) {
        this.parentMachine = parentMachine;
    }

    @Override
    public void setForwardedInitialEvent(Message<E> message) {
        this.forwardedInitialEvent = message;
    }

    public void setTransitionConflightPolicy(TransitionConflictPolicy transitionConflictPolicy) {
        this.transitionConflictPolicy = transitionConflictPolicy;
    }

    private Flux<StateMachineEventResult<S, E>> handleEvent(Message<E> message) {
        if (this.hasStateMachineError()) {
            return Flux.just(StateMachineEventResult.from(this, message, StateMachineEventResult.ResultType.DENIED));
        }
        return Mono.just(message).map(m -> this.getStateMachineInterceptors().preEvent(m, this)).flatMapMany(m -> this.acceptEvent((Message<E>)m)).onErrorResume(error -> Flux.just(StateMachineEventResult.from(this, message, StateMachineEventResult.ResultType.DENIED))).doOnNext(this.notifyOnDenied());
    }

    private Consumer<StateMachineEventResult<S, E>> notifyOnDenied() {
        return r -> {
            if (r.getResultType() == StateMachineEventResult.ResultType.DENIED) {
                this.notifyEventNotAccepted(this.buildStateContext(StateContext.Stage.EVENT_NOT_ACCEPTED, r.getMessage(), null, this.getRelayStateMachine(), this.getState(), null));
            }
        };
    }

    private Flux<StateMachineEventResult<S, E>> acceptEvent(Message<E> message) {
        return Flux.defer(() -> {
            DefaultTriggerContext triggerContext = new DefaultTriggerContext(message.getPayload());
            State cs = this.currentState;
            if (cs != null) {
                if (cs.shouldDefer(message)) {
                    this.stateMachineExecutor.queueDeferredEvent(message);
                    return Flux.just(StateMachineEventResult.from(this, message, StateMachineEventResult.ResultType.DEFERRED));
                }
                return cs.sendEvent(message).collectList().flatMapMany(l -> {
                    Flux ret = Flux.fromIterable((Iterable)l);
                    if (!l.stream().anyMatch(er -> er.getResultType() == StateMachineEventResult.ResultType.ACCEPTED)) {
                        Mono result = Flux.fromIterable(this.transitions).filter(transition -> cs != null && transition.getTrigger() != null).filter(transition -> StateMachineUtils.containsAtleastOne(transition.getSource().getIds(), cs.getIds())).flatMap(transition -> Mono.from(transition.getTrigger().evaluate(triggerContext)).flatMap(e -> {
                            if (e.booleanValue()) {
                                StateMachineExecutor.MonoSinkStateMachineExecutorCallback callback = new StateMachineExecutor.MonoSinkStateMachineExecutorCallback();
                                Mono sink = Mono.create((Consumer)callback);
                                return this.stateMachineExecutor.queueEvent(Mono.just((Object)message), callback).then(Mono.defer(() -> Mono.just(StateMachineEventResult.from(this, message, StateMachineEventResult.ResultType.ACCEPTED, (Mono<Void>)sink)))).onErrorResume(t -> Mono.defer(() -> Mono.just(StateMachineEventResult.from(this, message, StateMachineEventResult.ResultType.DENIED))));
                            }
                            return Mono.empty();
                        })).next().switchIfEmpty(Mono.defer(() -> Mono.just(StateMachineEventResult.from(this, message, StateMachineEventResult.ResultType.DENIED))));
                        ret = ret.concatWith((Publisher)result);
                    }
                    return ret;
                });
            }
            return Flux.just(StateMachineEventResult.from(this, message, StateMachineEventResult.ResultType.DENIED));
        });
    }

    private StateMachine<S, E> getRelayStateMachine() {
        return this.relay != null ? this.relay : this;
    }

    public String toString() {
        ArrayList<State<S, E>> all = new ArrayList<State<S, E>>();
        for (State<S, E> s : this.states) {
            all.addAll(s.getStates());
        }
        StringBuilder buf = new StringBuilder();
        for (State state : all) {
            buf.append(state.getId() + " ");
        }
        buf.append(" / ");
        if (this.currentState != null) {
            buf.append(StringUtils.collectionToCommaDelimitedString(this.currentState.getIds()));
        }
        buf.append(" / uuid=");
        buf.append(this.uuid);
        buf.append(" / id=");
        buf.append(this.id);
        return buf.toString();
    }

    @Override
    public void resetStateMachine(StateMachineContext<S, E> stateMachineContext) {
        this.resetStateMachineReactively(stateMachineContext).block();
    }

    @Override
    public Mono<Void> resetStateMachineReactively(StateMachineContext<S, E> stateMachineContext) {
        return Mono.defer(() -> {
            Mono mono;
            if (stateMachineContext == null) {
                log.info((Object)"Got null context, resetting to initial state, clearing extended state and machine id");
                this.currentState = this.initialState;
                this.extendedState.getVariables().clear();
                this.setId(null);
                return Mono.empty();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request to reset state machine: stateMachine=[" + this + "] stateMachineContext=[" + stateMachineContext + "]"));
            }
            this.setId(stateMachineContext.getId());
            Object state = stateMachineContext.getState();
            boolean stateSet = false;
            ArrayList<Mono> monos = new ArrayList<Mono>();
            for (State<S, E> state2 : this.getStates()) {
                for (State<S, E> ss : state2.getStates()) {
                    boolean enumMatch = false;
                    if (state instanceof Enum && ss.getId() instanceof Enum && state.getClass() == ss.getId().getClass() && ((Enum)ss.getId()).ordinal() == ((Enum)state).ordinal()) {
                        enumMatch = true;
                    }
                    if (state != null && (ss.getIds().contains(state) || enumMatch)) {
                        Mono mono2 = Mono.fromRunnable(() -> {
                            this.currentState = s;
                            this.lastState = this.currentState;
                        });
                        if (state2.isSubmachineState()) {
                            StateMachine submachine = ((AbstractState)state2).getSubmachine();
                            resetMono = Flux.fromIterable(stateMachineContext.getChilds()).map(child -> submachine.getStateMachineAccessor()).flatMap(region -> region.withRegion().resetStateMachineReactively(stateMachineContext)).then();
                            mono2 = mono2.then(resetMono);
                        } else if (state2.isOrthogonal() && stateMachineContext.getChilds() != null) {
                            Collection regions = ((AbstractState)state2).getRegions();
                            resetMono = Flux.fromIterable(regions).flatMap(region -> Flux.fromIterable(stateMachineContext.getChilds()).flatMap(child -> ((StateMachine)region).getStateMachineAccessor().withRegion().resetStateMachineReactively(child)).then()).then();
                            mono2 = mono2.thenEmpty((Publisher)resetMono);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("State reseted: stateMachine=[" + this + "] stateMachineContext=[" + stateMachineContext + "]"));
                        }
                        monos.add(mono2);
                        stateSet = true;
                        break;
                    }
                    if (stateMachineContext.getChilds() == null || stateMachineContext.getChilds().isEmpty()) continue;
                    if (state2.isOrthogonal()) {
                        Collection regions = ((AbstractState)state2).getRegions();
                        Mono resetMono = Flux.fromIterable(regions).flatMap(region -> Flux.fromIterable(stateMachineContext.getChilds()).flatMap(child -> {
                            if (ObjectUtils.nullSafeEquals((Object)region.getId(), (Object)child.getId())) {
                                return ((StateMachine)region).getStateMachineAccessor().withRegion().resetStateMachineReactively(child);
                            }
                            return Mono.empty();
                        }).then()).then();
                        monos.add(resetMono);
                        continue;
                    }
                    Mono mono2 = Mono.empty();
                    for (StateMachineContext child2 : stateMachineContext.getChilds()) {
                        Object state22 = child2.getState();
                        boolean enumMatch2 = false;
                        if (state22 instanceof Enum && ss.getId() instanceof Enum && state.getClass() == ss.getId().getClass() && ((Enum)ss.getId()).ordinal() == ((Enum)state22).ordinal()) {
                            enumMatch2 = true;
                        }
                        if (state22 == null || !ss.getIds().contains(state22) && !enumMatch2) continue;
                        mono2 = Mono.fromRunnable(() -> {
                            this.currentState = s;
                            this.lastState = this.currentState;
                        });
                        stateSet = true;
                        break;
                    }
                    monos.add(mono2);
                }
                if (!stateSet) continue;
                break;
            }
            if (this.history != null && stateMachineContext.getHistoryStates() != null) {
                mono = Mono.fromRunnable(() -> {
                    State<S, E> h = null;
                    for (State<S, E> hh : this.getStates()) {
                        if (!hh.getId().equals(stateMachineContext.getHistoryStates().get(null))) continue;
                        h = hh;
                        break;
                    }
                    if (h != null) {
                        ((HistoryPseudoState)this.history).setState(h);
                    }
                });
                monos.add(mono);
            }
            for (State state3 : this.getStates()) {
                Mono mono3 = Mono.fromRunnable(() -> {
                    StateMachine submachine;
                    PseudoState<S, E> submachineHistory;
                    if (StateMachineUtils.isPseudoState(s, PseudoStateKind.JOIN)) {
                        JoinPseudoState jps = (JoinPseudoState)s.getPseudoState();
                        Collection<S> ids = this.currentState.getIds();
                        jps.reset(ids);
                    }
                    if (s.isSubmachineState() && (submachineHistory = ((AbstractStateMachine)(submachine = ((AbstractState)s).getSubmachine())).getHistoryState()) != null) {
                        State h = null;
                        for (State hh : submachine.getStates()) {
                            if (!hh.getId().equals(stateMachineContext.getHistoryStates().get(s.getId()))) continue;
                            h = hh;
                            break;
                        }
                        if (h != null) {
                            ((HistoryPseudoState)submachineHistory).setState(h);
                        }
                    }
                });
                monos.add(mono3);
            }
            if (stateSet && stateMachineContext.getExtendedState() != null) {
                mono = Mono.fromRunnable(() -> {
                    this.extendedState.getVariables().clear();
                    this.extendedState.getVariables().putAll(stateMachineContext.getExtendedState().getVariables());
                });
                monos.add(mono);
            }
            return Flux.concat(monos).then();
        }).thenEmpty((Publisher)Mono.defer(() -> {
            if (this.currentState instanceof StateMachineReactiveLifecycle) {
                return ((StateMachineReactiveLifecycle)((Object)this.currentState)).startReactively();
            }
            return Mono.empty();
        }));
    }

    @Override
    public void addStateMachineInterceptor(StateMachineInterceptor<S, E> interceptor) {
        this.getStateMachineInterceptors().add(interceptor);
        this.stateMachineExecutor.addStateMachineInterceptor(interceptor);
    }

    @Override
    public void addStateMachineMonitor(StateMachineMonitor<S, E> monitor) {
        this.getStateMachineMonitor().register(monitor);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected Mono<Void> executeTriggerlessTransitions(StateMachine<S, E> stateMachine, StateContext<S, E> stateContext, State<S, E> state) {
        Mono mono = this.stateMachineExecutor.executeTriggerlessTransitions(stateContext, state);
        State<S, E> cs = this.currentState;
        if (cs != null && cs.isOrthogonal()) {
            Collection regions = ((AbstractState)cs).getRegions();
            Mono m = Flux.fromIterable(regions).flatMap(r -> ((AbstractStateMachine)r).executeTriggerlessTransitions(this, stateContext, state)).then();
            mono = mono.then(m);
        } else if (cs != null && cs.isSubmachineState()) {
            StateMachine submachine = ((AbstractState)cs).getSubmachine();
            Mono<Void> m = ((AbstractStateMachine)submachine).executeTriggerlessTransitions(this, stateContext, state);
            mono = mono.then(m);
        }
        return mono;
    }

    protected StateMachineExecutor<S, E> getStateMachineExecutor() {
        return this.stateMachineExecutor;
    }

    private boolean callPreStateChangeInterceptors(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        try {
            this.getStateMachineInterceptors().preStateChange(state, message, transition, this, stateMachine);
        }
        catch (Exception e) {
            log.info((Object)"Interceptors threw exception, skipping state change", (Throwable)e);
            return false;
        }
        return true;
    }

    private void callPostStateChangeInterceptors(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        try {
            this.getStateMachineInterceptors().postStateChange(state, message, transition, this, stateMachine);
        }
        catch (Exception e) {
            log.warn((Object)"Interceptors threw exception in post state change", (Throwable)e);
        }
    }

    private boolean isInitialTransition(Transition<S, E> transition) {
        return transition != null && transition.getKind() == TransitionKind.INITIAL;
    }

    private Mono<Void> switchToState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        return Mono.defer(() -> {
            if (!(this.isInitialTransition(transition) || StateMachineUtils.isTransientPseudoState(state) || this.callPreStateChangeInterceptors(state, message, transition, stateMachine))) {
                return Mono.empty();
            }
            StateContext<S, E> stateContext = this.buildStateContext(StateContext.Stage.STATE_CHANGED, message, transition, stateMachine);
            return Mono.from(this.followLinkedPseudoStates(state, stateContext)).flatMap(toState -> {
                PseudoStateKind kind;
                PseudoStateKind pseudoStateKind = kind = state.getPseudoState() != null ? state.getPseudoState().getKind() : null;
                if (kind != null && kind != PseudoStateKind.INITIAL && kind != PseudoStateKind.JOIN && kind != PseudoStateKind.FORK && kind != PseudoStateKind.END) {
                    this.callPreStateChangeInterceptors((State<S, E>)toState, message, transition, stateMachine);
                }
                PseudoStateKind pseudoStateKind2 = kind = toState.getPseudoState() != null ? toState.getPseudoState().getKind() : null;
                if (kind == PseudoStateKind.FORK) {
                    Mono<Void> ret1 = this.exitCurrentState((State<S, E>)toState, message, transition, stateMachine);
                    ForkPseudoState fps = (ForkPseudoState)toState.getPseudoState();
                    Mono ret2 = Flux.fromIterable(fps.getForks()).flatMap(f -> {
                        this.callPreStateChangeInterceptors((State<S, E>)f, message, transition, stateMachine);
                        return this.setCurrentState((State<S, E>)f, message, transition, false, stateMachine, null, fps.getForks());
                    }).then();
                    return ret1.then(ret2);
                }
                ArrayList<State<S, State>> targets = new ArrayList<State<S, State>>();
                targets.add((State<S, State>)toState);
                return this.setCurrentState((State<S, E>)toState, message, transition, true, stateMachine, null, (Collection<State<S, E>>)targets);
            });
        }).then(Mono.defer(() -> this.shouldComplete() ? this.stopReactively() : Mono.empty()));
    }

    private boolean shouldComplete() {
        return StateMachineUtils.isPseudoState(this.currentState, PseudoStateKind.END);
    }

    private Mono<State<S, E>> followLinkedPseudoStates(State<S, E> state, StateContext<S, E> stateContext) {
        PseudoStateKind kind;
        PseudoStateKind pseudoStateKind = kind = state.getPseudoState() != null ? state.getPseudoState().getKind() : null;
        if (kind == PseudoStateKind.INITIAL || kind == PseudoStateKind.FORK) {
            return Mono.just(state);
        }
        if (kind != null) {
            return Mono.from((Publisher)state.getPseudoState().entry(stateContext).flatMap(s -> this.followLinkedPseudoStates((State<S, E>)s, stateContext))).switchIfEmpty(Mono.just(state));
        }
        return Mono.just(state);
    }

    private void registerPseudoStateListener() {
        for (State<S, E> state : this.states) {
            PseudoState p = state.getPseudoState();
            if (p == null) continue;
            ArrayList listeners = new ArrayList();
            listeners.add(new PseudoStateListener<S, E>(){

                @Override
                public void onContext(PseudoStateContext<S, E> context) {
                    PseudoState pseudoState = context.getPseudoState();
                    State toStateOrig = AbstractStateMachine.this.findStateWithPseudoState(pseudoState);
                    StateContext stateContext = AbstractStateMachine.this.buildStateContext(StateContext.Stage.STATE_EXIT, null, null, AbstractStateMachine.this.getRelayStateMachine());
                    Mono toState = AbstractStateMachine.this.followLinkedPseudoStates(toStateOrig, stateContext);
                    toState.flatMap(toState2 -> Mono.defer(() -> {
                        Transition t = AbstractStateMachine.this.findTransition(toStateOrig, toState2);
                        return AbstractStateMachine.this.switchToState(toState2, null, t, AbstractStateMachine.this.getRelayStateMachine());
                    })).then().and(pseudoState.exit(stateContext)).subscribe();
                }
            });
            p.setPseudoStateListeners(listeners);
        }
    }

    private Transition<S, E> findTransition(State<S, E> from, State<S, E> to) {
        for (Transition<S, E> transition : this.transitions) {
            if (transition.getSource() != from || transition.getTarget() != to) continue;
            return transition;
        }
        return null;
    }

    private State<S, E> findStateWithPseudoState(PseudoState<S, E> pseudoState) {
        for (State<S, E> s : this.states) {
            if (s.getPseudoState() != pseudoState) continue;
            return s;
        }
        return null;
    }

    private StateContext<S, E> buildStateContext(StateContext.Stage stage, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        MessageHeaders messageHeaders = message != null ? message.getHeaders() : new MessageHeaders(new HashMap());
        return new DefaultStateContext<S, E>(stage, message, messageHeaders, this.extendedState, transition, stateMachine, null, null, null);
    }

    private StateContext<S, E> buildStateContext(StateContext.Stage stage, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Exception exception) {
        MessageHeaders messageHeaders = message != null ? message.getHeaders() : new MessageHeaders(new HashMap());
        return new DefaultStateContext<S, E>(stage, message, messageHeaders, this.extendedState, transition, stateMachine, null, null, exception);
    }

    private StateContext<S, E> buildStateContext(StateContext.Stage stage, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, State<S, E> source, State<S, E> target) {
        MessageHeaders messageHeaders = message != null ? message.getHeaders() : new MessageHeaders(new HashMap());
        return new DefaultStateContext<S, E>(stage, message, messageHeaders, this.extendedState, transition, stateMachine, source, target, null);
    }

    private StateContext<S, E> buildStateContext(StateContext.Stage stage, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        MessageHeaders messageHeaders = message != null ? message.getHeaders() : new MessageHeaders(new HashMap());
        return new DefaultStateContext<S, E>(stage, message, messageHeaders, this.extendedState, transition, stateMachine, null, null, sources, targets, null);
    }

    private State<S, E> findDeepParent(State<S, E> state) {
        for (State<S, E> s : this.states) {
            if (!s.getStates().contains(state)) continue;
            return s;
        }
        return null;
    }

    Mono<Void> setCurrentState(State<S, E> state, Message<E> message, Transition<S, E> transition, boolean exit, StateMachine<S, E> stateMachine) {
        return this.setCurrentState(state, message, transition, exit, stateMachine, null, null);
    }

    Mono<Void> setCurrentState(State<S, E> state, Message<E> message, Transition<S, E> transition, boolean exit, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        return this.setCurrentStateInternal3(state, message, transition, exit, stateMachine, sources, targets);
    }

    private Mono<Void> setCurrentStateInternal3(State<S, E> state, Message<E> message, Transition<S, E> transition, boolean exit, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        Function<State, State> mapFromTargetSub = in -> {
            boolean isTargetSubOf;
            if (transition != null && (isTargetSubOf = StateMachineUtils.isSubstate(state, transition.getSource())) && this.currentState == transition.getTarget()) {
                return transition.getSource();
            }
            return in;
        };
        Function<State, Mono> handleExit = in -> {
            if (exit) {
                return this.exitCurrentState((State<S, E>)in, message, transition, stateMachine, sources, targets).then(Mono.just((Object)in));
            }
            return Mono.just((Object)in);
        };
        Function<State, Mono> handleStart = in -> {
            if (!this.isRunning() && !this.isComplete()) {
                return this.startReactively().then(Mono.just((Object)in));
            }
            return Mono.just((Object)in);
        };
        Function<State, Mono> handleEntry1 = in -> {
            State<S, E> notifyFrom = this.currentState;
            this.currentState = in;
            return this.entryToState((State<S, E>)in, message, transition, stateMachine).then(Mono.just((Object)in)).doOnNext(s -> {
                if (!StateMachineUtils.isPseudoState(s, PseudoStateKind.JOIN)) {
                    this.notifyStateChanged(this.buildStateContext(StateContext.Stage.STATE_CHANGED, message, null, this.getRelayStateMachine(), notifyFrom, (State<S, E>)s));
                }
            });
        };
        Function<State, Mono> handleEntry2 = in -> {
            State<S, E> notifyFrom = this.currentState;
            State<S, E> findDeep = this.findDeepParent((State<S, E>)in);
            this.currentState = findDeep;
            return this.entryToState(findDeep, message, transition, stateMachine).then(Mono.just((Object)in)).doOnNext(s -> {
                if (!StateMachineUtils.isPseudoState(s, PseudoStateKind.JOIN)) {
                    this.notifyStateChanged(this.buildStateContext(StateContext.Stage.STATE_CHANGED, message, null, this.getRelayStateMachine(), notifyFrom, findDeep));
                }
            });
        };
        Function<State, Mono> handleStop = s -> {
            if (stateMachine != this && this.isComplete()) {
                return this.stopReactively().then(Mono.just((Object)s));
            }
            return Mono.just((Object)s);
        };
        Function<State, Mono> handleSubmachineOrRegions = in -> Mono.just((Object)in).flatMap(s -> {
            if (this.currentState == this.findDeepParent((State<S, E>)s)) {
                boolean isTargetSubOf;
                boolean bl = isTargetSubOf = transition != null && StateMachineUtils.isSubstate(state, transition.getSource());
                if (this.currentState.isSubmachineState()) {
                    State<S, E> findDeep;
                    StateMachine submachine = ((AbstractState)this.currentState).getSubmachine();
                    if (!submachine.isComplete() && submachine.getState() == s && this.currentState == (findDeep = this.findDeepParent((State<S, E>)s))) {
                        Mono mono = Mono.just((Object)s);
                        if (isTargetSubOf) {
                            mono = mono.flatMap(ss -> this.entryToState(this.currentState, message, transition, stateMachine).then(Mono.just((Object)ss)));
                        }
                        this.currentState = findDeep;
                        mono = mono.flatMap(ss -> ((AbstractStateMachine)submachine).setCurrentState((State)ss, message, transition, false, stateMachine)).then(Mono.empty());
                        return mono;
                    }
                } else if (this.currentState.isOrthogonal()) {
                    Collection regions = ((AbstractState)this.currentState).getRegions();
                    State<S, E> findDeep = this.findDeepParent((State<S, E>)s);
                    for (Region region : regions) {
                        if (region.getState() != s || this.currentState != findDeep) continue;
                        Mono mono = Mono.just((Object)s);
                        if (isTargetSubOf) {
                            mono = mono.flatMap(ss -> this.entryToState(this.currentState, message, transition, stateMachine).then(Mono.just((Object)ss)));
                        }
                        this.currentState = findDeep;
                        mono = mono.flatMap(ss -> ((AbstractStateMachine)region).setCurrentState((State)s, message, transition, false, stateMachine)).then(Mono.empty());
                        return mono;
                    }
                }
            }
            return Mono.just((Object)s);
        }).flatMap(s -> {
            boolean shouldTryEntry;
            Mono mono = Mono.just((Object)s);
            boolean bl = shouldTryEntry = this.findDeepParent((State<S, E>)s) != this.currentState;
            if (!shouldTryEntry && transition.getSource() == this.currentState && StateMachineUtils.isSubstate(this.currentState, transition.getTarget())) {
                shouldTryEntry = true;
            }
            this.currentState = this.findDeepParent((State<S, E>)s);
            if (shouldTryEntry) {
                mono = mono.flatMap(ss -> this.entryToState(this.currentState, message, transition, stateMachine, sources, targets)).then(Mono.just((Object)s));
            }
            if (this.currentState.isSubmachineState()) {
                StateMachine submachine = ((AbstractState)this.currentState).getSubmachine();
                mono = mono.flatMap(ss -> ((AbstractStateMachine)submachine).setCurrentState((State)s, message, transition, false, stateMachine).then(Mono.just((Object)ss)));
            } else if (this.currentState.isOrthogonal()) {
                Collection regions = ((AbstractState)this.currentState).getRegions();
                Mono ret = Flux.fromIterable(regions).flatMap(region -> ((AbstractStateMachine)region).setCurrentState((State)s, message, transition, false, stateMachine)).then(Mono.just((Object)s));
                mono = mono.then(ret);
            }
            return mono;
        });
        Function<State, Mono> handleStage1 = in -> Mono.just((Object)in).map(mapFromTargetSub).filter(s -> this.states.contains(s)).flatMap(handleExit).flatMap(handleEntry1).flatMap(handleStart).then(Mono.just((Object)in));
        Function<State, Mono> handleStage2 = in -> Mono.just((Object)in).filter(s -> this.currentState == null && !this.states.contains(s) && StateMachineUtils.isSubstate(this.findDeepParent((State<S, E>)s), state)).map(mapFromTargetSub).flatMap(handleExit).flatMap(handleEntry2).flatMap(handleStart).then(Mono.just((Object)in));
        Function<State, Mono> handleStage3 = in -> Mono.just((Object)in).map(mapFromTargetSub).filter(s -> this.currentState != null && !this.states.contains(s) && this.findDeepParent(state) != null).flatMap(handleExit).flatMap(handleSubmachineOrRegions).then(Mono.just((Object)in));
        Function<State, Mono> handleStage4 = in -> Mono.just((Object)in).filter(s -> this.history != null && transition.getKind() != TransitionKind.INITIAL).map(mapFromTargetSub).doOnNext(s -> {
            if (this.history.getKind() == PseudoStateKind.HISTORY_SHALLOW) {
                State<S, E> findDeep = this.findDeepParent(state);
                ((HistoryPseudoState)this.history).setState(findDeep);
            } else if (this.history.getKind() == PseudoStateKind.HISTORY_DEEP) {
                ((HistoryPseudoState)this.history).setState(s);
            }
        }).then(Mono.just((Object)in));
        Function<State, Mono> handleStage5 = in -> Mono.just((Object)in).flatMap(handleStop);
        return Mono.just(state).flatMap(handleStage1).flatMap(handleStage2).flatMap(handleStage3).flatMap(handleStage4).flatMap(handleStage5).then();
    }

    Mono<Void> exitCurrentState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        return this.exitCurrentState(state, message, transition, stateMachine, null, null);
    }

    Mono<Void> exitCurrentState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        if (this.currentState == null) {
            return Mono.empty();
        }
        if (this.currentState.isSubmachineState()) {
            StateMachine submachine = ((AbstractState)this.currentState).getSubmachine();
            Mono<Void> ret1 = ((AbstractStateMachine)submachine).exitCurrentState(state, message, transition, stateMachine);
            Mono<Void> ret2 = this.exitFromState(this.currentState, message, transition, stateMachine, sources, targets);
            return ret1.then(ret2);
        }
        if (this.currentState.isOrthogonal()) {
            Collection regions = ((AbstractState)this.currentState).getRegions();
            return Flux.fromIterable(regions).filter(r -> r.getStates().contains(state)).flatMap(r -> this.exitFromState(r.getState(), message, transition, stateMachine, sources, targets)).then().and(this.exitFromState(this.currentState, message, transition, stateMachine, sources, targets));
        }
        return this.exitFromState(this.currentState, message, transition, stateMachine, sources, targets);
    }

    private Mono<Void> exitFromState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        return this.exitFromState(state, message, transition, stateMachine, null, null);
    }

    private Mono<Void> exitFromState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        if (state == null) {
            return Mono.empty();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Trying Exit state=[" + state + "]"));
        }
        StateContext<S, E> stateContext = this.buildStateContext(StateContext.Stage.STATE_EXIT, message, transition, stateMachine);
        if (transition != null) {
            State<S, E> findDeep = this.findDeepParent(transition.getTarget());
            boolean isTargetSubOfOtherState = findDeep != null && findDeep != this.currentState;
            boolean isSubOfSource = StateMachineUtils.isSubstate(transition.getSource(), this.currentState);
            boolean isSubOfTarget = StateMachineUtils.isSubstate(transition.getTarget(), this.currentState);
            if (transition.getKind() == TransitionKind.LOCAL && StateMachineUtils.isSubstate(transition.getSource(), transition.getTarget()) && transition.getSource() == this.currentState) {
                return Mono.empty();
            }
            if (transition.getKind() == TransitionKind.LOCAL && StateMachineUtils.isSubstate(transition.getTarget(), transition.getSource()) && transition.getTarget() == this.currentState) {
                return Mono.empty();
            }
            if (!(this.currentState == transition.getSource() && this.currentState == transition.getTarget() || !isSubOfSource && !isSubOfTarget && this.currentState == transition.getSource() || !isSubOfSource && !isSubOfTarget && this.currentState == transition.getTarget() || isTargetSubOfOtherState || !isSubOfSource && !isSubOfTarget && findDeep == null || !isSubOfSource && !isSubOfTarget && transition.getSource() == this.currentState && StateMachineUtils.isSubstate(this.currentState, transition.getTarget()))) {
                if (StateMachineUtils.isNormalPseudoState(transition.getTarget())) {
                    if (this.isPseudoStateSubstate(findDeep, targets)) {
                        return Mono.empty();
                    }
                    if (StateMachineUtils.isSubstate(this.currentState, transition.getTarget())) {
                        if (this.currentState.isSubmachineState() && StateMachineUtils.isPseudoState(transition.getTarget(), PseudoStateKind.FORK)) {
                            return Mono.empty();
                        }
                        if (this.currentState.isOrthogonal()) {
                            return Mono.empty();
                        }
                    }
                } else if (!(findDeep != null && findDeep != state && findDeep.getStates().contains(state) || isSubOfSource || isSubOfTarget)) {
                    return Mono.empty();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit state=[" + state + "]"));
        }
        this.notifyStateExited(this.buildStateContext(StateContext.Stage.STATE_EXIT, message, null, this.getRelayStateMachine(), state, null));
        return state.exit(stateContext);
    }

    private boolean isPseudoStateSubstate(State<S, E> left, Collection<State<S, E>> rights) {
        if (rights == null || left == null) {
            return false;
        }
        for (State<S, E> s : rights) {
            if (!StateMachineUtils.isSubstate(left, s)) continue;
            return true;
        }
        return false;
    }

    private Mono<Void> entryToState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        return this.entryToState(state, message, transition, stateMachine, null, null);
    }

    private Mono<Void> entryToState(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, Collection<State<S, E>> sources, Collection<State<S, E>> targets) {
        if (state == null) {
            return Mono.empty();
        }
        this.callPostStateChangeInterceptors(state, message, transition, stateMachine);
        log.debug((Object)("Trying Enter state=[" + state + "]"));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Trying Enter state=[" + state + "]"));
        }
        StateContext<S, E> stateContext = this.buildStateContext(StateContext.Stage.STATE_ENTRY, message, transition, stateMachine, sources, targets);
        if (transition != null) {
            State<S, E> findDeep1 = this.findDeepParent(transition.getTarget());
            State<S, E> findDeep2 = this.findDeepParent(transition.getSource());
            boolean isComingFromOtherSubmachine = findDeep1 != null && findDeep2 != null && findDeep2 != this.currentState;
            boolean isSubOfSource = StateMachineUtils.isSubstate(transition.getSource(), this.currentState);
            boolean isSubOfTarget = StateMachineUtils.isSubstate(transition.getTarget(), this.currentState);
            if (transition.getKind() == TransitionKind.LOCAL && StateMachineUtils.isSubstate(transition.getSource(), transition.getTarget()) && transition.getSource() == this.currentState) {
                return Mono.empty();
            }
            if (transition.getKind() == TransitionKind.LOCAL && StateMachineUtils.isSubstate(transition.getTarget(), transition.getSource()) && transition.getTarget() == this.currentState) {
                return Mono.empty();
            }
            if ((this.currentState != transition.getSource() || this.currentState != transition.getTarget()) && (isSubOfSource || isSubOfTarget || this.currentState != transition.getTarget()) && !isComingFromOtherSubmachine && (isSubOfSource || isSubOfTarget || findDeep2 != null) && (isSubOfSource && !isSubOfTarget && this.currentState == transition.getTarget() ? AbstractStateMachine.isDirectSubstate(transition.getSource(), transition.getTarget()) && transition.getKind() != TransitionKind.LOCAL && AbstractStateMachine.isInitial(transition.getTarget()) : (isSubOfSource || isSubOfTarget || transition.getSource() != this.currentState || !StateMachineUtils.isSubstate(this.currentState, transition.getTarget())) && !isSubOfSource && !isSubOfTarget && !StateMachineUtils.isTransientPseudoState(transition.getTarget()))) {
                return Mono.empty();
            }
        }
        if (!StateMachineUtils.isPseudoState(state, PseudoStateKind.JOIN)) {
            this.notifyStateEntered(this.buildStateContext(StateContext.Stage.STATE_ENTRY, message, transition, this.getRelayStateMachine(), null, state));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter state=[" + state + "]"));
        }
        return state.entry(stateContext);
    }

    private static <S, E> boolean isInitial(State<S, E> state) {
        return state.getPseudoState() != null && state.getPseudoState().getKind() == PseudoStateKind.INITIAL;
    }

    private static <S, E> boolean isDirectSubstate(State<S, E> left, State<S, E> right) {
        if (left != null && left.isSubmachineState()) {
            StateMachine submachine = ((AbstractState)left).getSubmachine();
            return submachine.getStates().contains(right);
        }
        return false;
    }
}

