/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachineEventResult;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.region.RegionExecutionPolicy;
import org.springframework.statemachine.state.AbstractState;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.StateMachineUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RegionState<S, E>
extends AbstractState<S, E> {
    private RegionExecutionPolicy regionExecutionPolicy;

    public RegionState(S id, Collection<Region<S, E>> regions) {
        super(id, null, null, null, null, regions);
    }

    public RegionState(S id, Collection<Region<S, E>> regions, Collection<E> deferred) {
        super(id, deferred, null, null, null, regions);
    }

    public RegionState(S id, Collection<Region<S, E>> regions, PseudoState<S, E> pseudoState) {
        super(id, null, null, null, pseudoState, regions);
    }

    public RegionState(S id, Collection<Region<S, E>> regions, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, PseudoState<S, E> pseudoState) {
        super(id, deferred, entryActions, exitActions, pseudoState, regions);
    }

    public RegionState(S id, Collection<Region<S, E>> regions, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions) {
        super(id, deferred, entryActions, exitActions, null, regions);
    }

    @Override
    public Flux<StateMachineEventResult<S, E>> sendEvent(Message<E> event) {
        if (this.regionExecutionPolicy == RegionExecutionPolicy.PARALLEL) {
            return Flux.fromIterable(this.getRegions()).parallel().runOn(Schedulers.parallel()).flatMap(r -> r.sendEvent(Mono.just((Object)event))).sequential();
        }
        return Flux.fromIterable(this.getRegions()).flatMap(r -> r.sendEvent(Mono.just((Object)event)));
    }

    @Override
    public boolean shouldDefer(Message<E> event) {
        boolean defer = true;
        if (this.getRegions() != null) {
            for (Region r : this.getRegions()) {
                State state = r.getState();
                if (state == null) continue;
                if (state.getDeferredEvents().contains(event.getPayload())) {
                    defer &= true;
                    continue;
                }
                defer = false;
            }
        }
        return defer;
    }

    @Override
    public Mono<Void> exit(StateContext<S, E> context) {
        Mono actions = Flux.fromIterable(this.getExitActions()).flatMap(a -> this.executeAction(a, context)).then();
        Mono regionsThenActions = Flux.fromIterable(this.getRegions()).flatMap(r -> r.stopReactively()).then(actions);
        return super.exit(context).then(regionsThenActions);
    }

    private Mono<Void> startOrEntry(StateContext<S, E> context) {
        if (this.getPseudoState() != null && this.getPseudoState().getKind() == PseudoStateKind.INITIAL) {
            if (this.regionExecutionPolicy == RegionExecutionPolicy.PARALLEL) {
                return Flux.fromIterable(this.getRegions()).filter(r -> !StateMachineUtils.containsAtleastOne(r.getStates(), context.getTargets())).parallel().runOn(Schedulers.parallel()).flatMap(r -> r.startReactively()).sequential().then();
            }
            return Flux.fromIterable(this.getRegions()).filter(r -> !StateMachineUtils.containsAtleastOne(r.getStates(), context.getTargets())).flatMap(r -> r.startReactively()).then();
        }
        return Flux.fromIterable(this.getRegions()).filter(r -> r.getState() != null).doOnNext(r -> r.getState().entry(context)).then();
    }

    @Override
    public Mono<Void> entry(StateContext<S, E> context) {
        Mono actions = Flux.fromIterable(this.getEntryActions()).flatMap(a -> this.executeAction(a, context)).then();
        return super.entry(context).and((Publisher)actions).then(this.startOrEntry(context));
    }

    @Override
    public Collection<S> getIds() {
        ArrayList ids = new ArrayList();
        if (this.getId() != null) {
            ids.add(this.getId());
        }
        for (Region r : this.getRegions()) {
            State s = r.getState();
            if (s == null) continue;
            ids.addAll(s.getIds());
        }
        return ids;
    }

    @Override
    public Collection<State<S, E>> getStates() {
        ArrayList states = new ArrayList();
        states.add(this);
        for (Region r : this.getRegions()) {
            for (State s : r.getStates()) {
                states.addAll(s.getStates());
            }
        }
        return states;
    }

    public void setRegionExecutionPolicy(RegionExecutionPolicy regionExecutionPolicy) {
        this.regionExecutionPolicy = regionExecutionPolicy;
    }

    @Override
    public String toString() {
        return "RegionState [getIds()=" + this.getIds() + ", getClass()=" + this.getClass() + ", hashCode()=" + this.hashCode() + ", toString()=" + super.toString() + "]";
    }
}

