/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.AbstractSimpleState;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.support.StateMachineUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ObjectState<S, E>
extends AbstractSimpleState<S, E> {
    private static final Log log = LogFactory.getLog(ObjectState.class);

    public ObjectState(S id) {
        super(id);
    }

    public ObjectState(S id, PseudoState<S, E> pseudoState) {
        super(id, pseudoState);
    }

    public ObjectState(S id, Collection<E> deferred) {
        super(id, deferred);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions) {
        super(id, deferred, entryActions, exitActions);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, PseudoState<S, E> pseudoState) {
        super(id, deferred, entryActions, exitActions, pseudoState);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions) {
        super(id, deferred, entryActions, exitActions, pseudoState, regions);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, PseudoState<S, E> pseudoState, StateMachine<S, E> submachine) {
        super(id, deferred, entryActions, exitActions, pseudoState, submachine);
    }

    public ObjectState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, Collection<Function<StateContext<S, E>, Mono<Void>>> stateActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions, StateMachine<S, E> submachine) {
        super(id, deferred, entryActions, exitActions, stateActions, pseudoState, regions, submachine);
    }

    @Override
    public Mono<Void> exit(StateContext<S, E> context) {
        Mono actions = Flux.fromIterable(this.getExitActions()).flatMap(a -> this.executeAction(a, context).doOnError(e -> log.warn((Object)"Exit action execution error", e))).onErrorResume(StateMachineUtils.resumeErrorToContext()).then();
        return super.exit(context).and((Publisher)actions);
    }

    @Override
    public Mono<Void> entry(StateContext<S, E> context) {
        Mono actions = Flux.fromIterable(this.getEntryActions()).flatMap(a -> this.executeAction(a, context).doOnError(e -> log.warn((Object)"Entry action execution error", e))).onErrorResume(StateMachineUtils.resumeErrorToContext()).then();
        return actions.and(super.entry(context));
    }

    @Override
    public String toString() {
        return "ObjectState [getIds()=" + this.getIds() + ", getClass()=" + this.getClass() + ", hashCode()=" + this.hashCode() + ", toString()=" + super.toString() + "]";
    }
}

