/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.state.AbstractPseudoState;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateHolder;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class HistoryPseudoState<S, E>
extends AbstractPseudoState<S, E> {
    private final StateHolder<S, E> defaultState;
    private final StateHolder<S, E> containingState;
    private State<S, E> state;

    public HistoryPseudoState(PseudoStateKind kind, StateHolder<S, E> containingState) {
        this(kind, containingState, new StateHolder(null));
    }

    public HistoryPseudoState(PseudoStateKind kind, StateHolder<S, E> defaultState, StateHolder<S, E> containingState) {
        super(kind);
        Assert.isTrue((PseudoStateKind.HISTORY_SHALLOW == kind || PseudoStateKind.HISTORY_DEEP == kind ? 1 : 0) != 0, (String)"Pseudo state must be either shallow or deep");
        Assert.notNull(defaultState, (String)"Holder defaultState must be set");
        Assert.notNull(containingState, (String)"Holder containingState must be set");
        this.defaultState = defaultState;
        this.containingState = containingState;
    }

    @Override
    public Mono<State<S, E>> entry(StateContext<S, E> context) {
        if (this.state == null) {
            if (this.defaultState.getState() == null) {
                return Mono.just(this.containingState.getState());
            }
            return Mono.just(this.defaultState.getState());
        }
        if (this.defaultState.getState() != null && this.state.getPseudoState() != null && this.state.getPseudoState().getKind() == PseudoStateKind.END) {
            return Mono.just(this.defaultState.getState());
        }
        return Mono.just(this.state);
    }

    public void setState(State<S, E> state) {
        this.state = state;
    }

    public State<S, E> getState() {
        return this.state;
    }
}

