/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineEventResult;
import org.springframework.statemachine.action.ActionListener;
import org.springframework.statemachine.action.CompositeActionListener;
import org.springframework.statemachine.action.StateDoActionPolicy;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.CompositeStateListener;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateListener;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.support.StateMachineUtils;
import org.springframework.statemachine.trigger.Trigger;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;

public abstract class AbstractState<S, E>
extends LifecycleObjectSupport
implements State<S, E> {
    private static final Log log = LogFactory.getLog(AbstractState.class);
    private final S id;
    private final PseudoState<S, E> pseudoState;
    private final Collection<E> deferred;
    private final Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions;
    private final Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions;
    private final Collection<Function<StateContext<S, E>, Mono<Void>>> stateActions;
    private final List<ScheduledAction> scheduledActions = new ArrayList<ScheduledAction>();
    private final Collection<Region<S, E>> regions = new ArrayList<Region<S, E>>();
    private final StateMachine<S, E> submachine;
    private List<Trigger<S, E>> triggers = new ArrayList<Trigger<S, E>>();
    private final CompositeStateListener<S, E> stateListener = new CompositeStateListener();
    private CompositeActionListener<S, E> actionListener;
    private final List<StateMachineListener<S, E>> completionListeners = new CopyOnWriteArrayList<StateMachineListener<S, E>>();
    private StateDoActionPolicy stateDoActionPolicy;
    private Long stateDoActionPolicyTimeout;
    private final Queue<Disposable> disposables = new ConcurrentLinkedDeque<Disposable>();

    public AbstractState(S id, PseudoState<S, E> pseudoState) {
        this(id, null, null, null, pseudoState);
    }

    public AbstractState(S id, Collection<E> deferred) {
        this(id, deferred, null, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions) {
        this(id, deferred, entryActions, exitActions, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, PseudoState<S, E> pseudoState) {
        this(id, deferred, entryActions, exitActions, pseudoState, null, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, PseudoState<S, E> pseudoState, StateMachine<S, E> submachine) {
        this(id, deferred, entryActions, exitActions, pseudoState, null, submachine);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions) {
        this(id, deferred, entryActions, exitActions, pseudoState, regions, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions, StateMachine<S, E> submachine) {
        this(id, deferred, entryActions, exitActions, null, pseudoState, regions, submachine);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<Function<StateContext<S, E>, Mono<Void>>> entryActions, Collection<Function<StateContext<S, E>, Mono<Void>>> exitActions, Collection<Function<StateContext<S, E>, Mono<Void>>> stateActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions, StateMachine<S, E> submachine) {
        this.id = id;
        this.deferred = deferred != null ? deferred : Collections.emptySet();
        this.entryActions = entryActions != null ? entryActions : Collections.emptySet();
        this.exitActions = exitActions != null ? exitActions : Collections.emptySet();
        this.stateActions = stateActions != null ? stateActions : Collections.emptySet();
        this.pseudoState = pseudoState;
        if (regions != null) {
            this.regions.addAll(regions);
        }
        this.submachine = submachine;
    }

    @Override
    public Flux<StateMachineEventResult<S, E>> sendEvent(Message<E> event) {
        return Flux.empty();
    }

    @Override
    public boolean shouldDefer(Message<E> event) {
        return this.deferred.contains(event.getPayload());
    }

    @Override
    public Mono<Void> exit(StateContext<S, E> context) {
        return Mono.defer(() -> {
            block4: {
                block3: {
                    if (this.submachine == null) break block3;
                    for (StateMachineListener<S, E> l : this.completionListeners) {
                        this.submachine.removeStateListener(l);
                    }
                    break block4;
                }
                if (this.regions.isEmpty()) break block4;
                for (Region<S, E> region : this.regions) {
                    for (StateMachineListener<S, E> l : this.completionListeners) {
                        region.removeStateListener(l);
                    }
                }
            }
            return Mono.empty();
        }).then(Mono.fromRunnable(() -> this.completionListeners.clear())).then(this.cancelStateActions()).then(Mono.fromRunnable(() -> {
            this.stateListener.onExit(context);
            this.disarmTriggers();
        })).doFinally(signal -> this.disposeDisposables());
    }

    @Override
    public Mono<Void> entry(StateContext<S, E> context) {
        return Mono.defer(() -> {
            if (this.submachine != null) {
                Disposable disposable = Mono.just(this.submachine).flatMap(submachine -> this.completionStateListenerSink((Region<S, E>)submachine)).then(Mono.fromRunnable(() -> this.notifyStateOnComplete(context))).subscribe();
                this.disposables.add(disposable);
            } else if (!this.regions.isEmpty()) {
                Flux.fromIterable(this.regions).flatMap(region -> this.completionStateListenerSink((Region<S, E>)region)).then(this.handleStateDoOnComplete(context)).then(Mono.fromRunnable(() -> this.notifyStateOnComplete(context))).subscribe();
            }
            this.stateListener.onEntry(context);
            this.armTriggers();
            return Mono.empty();
        }).then(this.scheduleStateActions(context));
    }

    @Override
    public S getId() {
        return this.id;
    }

    @Override
    public abstract Collection<S> getIds();

    @Override
    public abstract Collection<State<S, E>> getStates();

    @Override
    public PseudoState<S, E> getPseudoState() {
        return this.pseudoState;
    }

    @Override
    public Collection<E> getDeferredEvents() {
        return this.deferred;
    }

    @Override
    public Collection<Function<StateContext<S, E>, Mono<Void>>> getEntryActions() {
        return this.entryActions;
    }

    @Override
    public Collection<Function<StateContext<S, E>, Mono<Void>>> getStateActions() {
        return this.stateActions;
    }

    @Override
    public Collection<Function<StateContext<S, E>, Mono<Void>>> getExitActions() {
        return this.exitActions;
    }

    @Override
    public boolean isComposite() {
        return !this.regions.isEmpty();
    }

    @Override
    public boolean isOrthogonal() {
        return this.regions.size() > 1;
    }

    @Override
    public boolean isSimple() {
        return !this.isSubmachineState() && !this.isComposite();
    }

    @Override
    public boolean isSubmachineState() {
        return this.submachine != null;
    }

    @Override
    public void addStateListener(StateListener<S, E> listener) {
        this.stateListener.register(listener);
    }

    @Override
    public void removeStateListener(StateListener<S, E> listener) {
        this.stateListener.unregister(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionListener(ActionListener<S, E> listener) {
        AbstractState abstractState = this;
        synchronized (abstractState) {
            if (this.actionListener == null) {
                this.actionListener = new CompositeActionListener();
            }
            this.actionListener.register(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionListener(ActionListener<S, E> listener) {
        AbstractState abstractState = this;
        synchronized (abstractState) {
            if (this.actionListener != null) {
                this.actionListener.unregister(listener);
            }
        }
    }

    @Override
    protected Mono<Void> doPreStartReactively() {
        return Mono.fromRunnable(() -> this.armTriggers());
    }

    @Override
    protected Mono<Void> doPreStopReactively() {
        return Mono.fromRunnable(() -> this.disarmTriggers());
    }

    public StateMachine<S, E> getSubmachine() {
        return this.submachine;
    }

    public Collection<Region<S, E>> getRegions() {
        return this.regions;
    }

    public void setTriggers(List<Trigger<S, E>> triggers) {
        if (triggers != null) {
            this.triggers = triggers;
        } else {
            this.triggers.clear();
        }
    }

    public List<Trigger<S, E>> getTriggers() {
        return this.triggers;
    }

    public void setStateDoActionPolicy(StateDoActionPolicy stateDoActionPolicy) {
        this.stateDoActionPolicy = stateDoActionPolicy;
    }

    public void setStateDoActionPolicyTimeout(Long stateDoActionPolicyTimeout) {
        this.stateDoActionPolicyTimeout = stateDoActionPolicyTimeout;
    }

    protected void armTriggers() {
        for (Trigger<S, E> trigger : this.triggers) {
            trigger.arm();
        }
    }

    protected void disarmTriggers() {
        for (Trigger<S, E> trigger : this.triggers) {
            trigger.disarm();
        }
    }

    private Mono<Void> completionStateListenerSink(final Region<S, E> region) {
        return Mono.create(sink -> {
            StateMachineListenerAdapter listener = new StateMachineListenerAdapter<S, E>((MonoSink)sink){
                final /* synthetic */ MonoSink val$sink;
                {
                    this.val$sink = monoSink;
                }

                @Override
                public void stateContext(StateContext<S, E> stateContext) {
                    if (stateContext.getStage() == StateContext.Stage.STATEMACHINE_STOP && stateContext.getStateMachine() == region && region.isComplete()) {
                        AbstractState.this.completionListeners.remove(this);
                        region.removeStateListener(this);
                        this.val$sink.success();
                    }
                }
            };
            this.completionListeners.add(listener);
            region.addStateListener(listener);
        });
    }

    private void disposeDisposables() {
        Disposable disposable;
        while ((disposable = this.disposables.poll()) != null) {
            disposable.dispose();
        }
    }

    private Mono<Void> scheduleStateActions(StateContext<S, E> context) {
        return Mono.defer(() -> {
            AtomicInteger completionCount = new AtomicInteger(this.stateActions.size());
            Long timeout = this.resolveDoActionTimeout(context);
            return Flux.fromIterable(this.stateActions).doOnNext(stateAction -> this.executeAction((Function<StateContext<S, E>, Mono<Void>>)stateAction, context).onErrorResume(t -> Mono.empty()).subscribeOn(Schedulers.parallel()).doOnSubscribe(subscription -> {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding new scheduled action with subscription=" + subscription));
                }
                this.scheduledActions.add(new ScheduledAction((Subscription)subscription, timeout, System.currentTimeMillis()));
            }).then(this.handleCompleteOrEmpty1(context, completionCount)).subscribe()).then(this.handleCompleteOrEmpty2(context, completionCount));
        });
    }

    private Mono<Void> handleCompleteOrEmpty1(StateContext<S, E> context, AtomicInteger completionCount) {
        return Mono.defer(() -> {
            log.debug((Object)("handleCompleteOrEmpty1 " + completionCount + " " + this.stateActions));
            if (completionCount.decrementAndGet() <= 0 && this.stateActions.size() > 0) {
                return this.handleStateDoOnComplete(context).then(Mono.fromRunnable(() -> this.notifyStateOnComplete(context)));
            }
            return Mono.empty();
        });
    }

    private Mono<Void> handleCompleteOrEmpty2(StateContext<S, E> context, AtomicInteger completionCount) {
        return Mono.defer(() -> {
            if (this.isSimple() && this.stateActions.size() == 0) {
                return this.handleStateDoOnComplete(context).then(Mono.fromRunnable(() -> this.notifyStateOnComplete(context)));
            }
            return Mono.empty();
        });
    }

    private Mono<Void> cancelStateActions() {
        return Flux.fromIterable(this.scheduledActions).flatMap(stateAction -> {
            if (stateAction.getNeededDelayNow().toMillis() > 0L) {
                return Mono.delay((Duration)stateAction.getNeededDelayNow()).thenReturn(stateAction);
            }
            return Mono.just((Object)stateAction);
        }).doOnNext(stateAction -> {
            if (stateAction.subscription != null) {
                log.debug((Object)("About to dispose subscription " + stateAction.subscription));
                stateAction.subscription.cancel();
            }
        }).thenEmpty((Publisher)Mono.fromRunnable(() -> this.scheduledActions.clear()));
    }

    protected Mono<Void> executeAction(Function<StateContext<S, E>, Mono<Void>> action, StateContext<S, E> context) {
        return Mono.just(action).flatMap(a -> {
            long now = System.currentTimeMillis();
            return ((Mono)a.apply(context)).thenEmpty((Publisher)Mono.fromRunnable(() -> {
                if (this.actionListener != null) {
                    try {
                        this.actionListener.onExecute(context.getStateMachine(), action, System.currentTimeMillis() - now);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Error with actionListener", (Throwable)e);
                    }
                }
            }));
        });
    }

    protected Mono<Void> handleStateDoOnComplete(StateContext<S, E> context) {
        return this.stateListener.doOnComplete(context);
    }

    protected void notifyStateOnComplete(StateContext<S, E> context) {
        this.stateListener.onComplete(context);
    }

    private Long resolveDoActionTimeout(StateContext<S, E> context) {
        Long timeout = null;
        if (this.stateDoActionPolicy == StateDoActionPolicy.TIMEOUT_CANCEL && (timeout = StateMachineUtils.getMessageHeaderDoActionTimeout(context)) == null) {
            timeout = this.stateDoActionPolicyTimeout;
        }
        return timeout;
    }

    public String toString() {
        return "AbstractState [id=" + this.id + ", pseudoState=" + this.pseudoState + ", deferred=" + this.deferred + ", entryActions=" + this.entryActions + ", exitActions=" + this.exitActions + ", stateActions=" + this.stateActions + ", regions=" + this.regions + ", submachine=" + this.submachine + "]";
    }

    private static class ScheduledAction {
        Subscription subscription;
        Long timeout;
        Long subscribeTime;

        ScheduledAction(Subscription subscription, Long timeout, Long subscribeTime) {
            this.subscription = subscription;
            this.timeout = timeout;
            this.subscribeTime = subscribeTime;
        }

        Duration getNeededDelayNow() {
            long delay = 0L;
            if (this.subscribeTime != null && this.timeout != null) {
                long tocancel;
                long now = System.currentTimeMillis();
                delay = now > (tocancel = this.subscribeTime + this.timeout) ? 0L : tocancel - now;
            }
            return Duration.ofMillis(delay);
        }
    }
}

