/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.security;

import java.util.Collection;
import org.springframework.messaging.Message;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class EventVoter<T>
implements AccessDecisionVoter<Message<T>> {
    private String eventPrefix = "EVENT_";

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().startsWith(this.getEventPrefix());
    }

    public boolean supports(Class<?> clazz) {
        return Message.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, Message<T> event, Collection<ConfigAttribute> attributes) {
        int result = 0;
        if (authentication == null) {
            return result;
        }
        Object e = event.getPayload();
        for (ConfigAttribute attribute : attributes) {
            if (!this.supports(attribute)) continue;
            result = -1;
            String attr = attribute.getAttribute();
            if (!attr.startsWith(this.getEventPrefix()) || !attr.equals(this.getEventPrefix() + e.toString())) continue;
            return 1;
        }
        return result;
    }

    public String getEventPrefix() {
        return this.eventPrefix;
    }
}

