/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.model.verifier;

import java.util.Iterator;
import org.springframework.statemachine.config.model.MalformedConfigurationException;
import org.springframework.statemachine.config.model.StateData;
import org.springframework.statemachine.config.model.StateMachineModel;
import org.springframework.statemachine.config.model.StatesData;
import org.springframework.statemachine.config.model.verifier.StateMachineModelVerifier;
import org.springframework.statemachine.support.tree.Tree;
import org.springframework.statemachine.support.tree.TreeTraverser;

public class BaseStructureVerifier<S, E>
implements StateMachineModelVerifier<S, E> {
    @Override
    public void verify(StateMachineModel<S, E> model) {
        if (model.getTransitionsData().getTransitions().isEmpty()) {
            MalformedConfigurationException exception = new MalformedConfigurationException("Must have at least one transition");
            throw exception;
        }
        Iterator<Tree.Node<StateData<S, E>>> iterator = this.buildStateDataIterator(model.getStatesData());
        while (iterator.hasNext()) {
            Tree.Node<StateData<S, E>> node = iterator.next();
            if (node.getData() != null) continue;
            boolean initialStateFound = false;
            for (Tree.Node<StateData<S, E>> n : node.getChildren()) {
                StateData<S, E> data = n.getData();
                if (!data.isInitial()) continue;
                initialStateFound = true;
            }
            if (initialStateFound) continue;
            MalformedConfigurationException exception = new MalformedConfigurationException("Initial state not set");
            for (Tree.Node<StateData<S, E>> c : node.getChildren()) {
                exception.addTrace(c.getData().toString());
            }
            throw exception;
        }
    }

    private Iterator<Tree.Node<StateData<S, E>>> buildStateDataIterator(StatesData<S, E> stateMachineStates) {
        Tree<StateData<S, E>> tree = new Tree<StateData<S, E>>();
        for (StateData<S, E> stateData : stateMachineStates.getStateData()) {
            S id = stateData.getState();
            Object parent = stateData.getParent();
            tree.add(stateData, id, parent);
        }
        TreeTraverser traverser = new TreeTraverser<Tree.Node<StateData<S, E>>>(){

            @Override
            public Iterable<Tree.Node<StateData<S, E>>> children(Tree.Node<StateData<S, E>> root) {
                return root.getChildren();
            }
        };
        Iterable postOrderTraversal = traverser.postOrderTraversal(tree.getRoot());
        Iterator<Tree.Node<StateData<S, E>>> iterator = postOrderTraversal.iterator();
        return iterator;
    }
}

