/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.model;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.statemachine.action.StateDoActionPolicy;
import org.springframework.statemachine.config.model.verifier.DefaultStateMachineModelVerifier;
import org.springframework.statemachine.config.model.verifier.StateMachineModelVerifier;
import org.springframework.statemachine.ensemble.StateMachineEnsemble;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.monitor.StateMachineMonitor;
import org.springframework.statemachine.region.RegionExecutionPolicy;
import org.springframework.statemachine.security.SecurityRule;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.transition.TransitionConflictPolicy;

public class ConfigurationData<S, E> {
    private final String machineId;
    private final BeanFactory beanFactory;
    private final boolean autoStart;
    private final TransitionConflictPolicy transitionConflictPolicy;
    private final StateDoActionPolicy stateDoActionPolicy;
    private final Long stateDoActionPolicyTimeout;
    private final StateMachineEnsemble<S, E> ensemble;
    private final List<StateMachineListener<S, E>> listeners;
    private final boolean securityEnabled;
    private final boolean verifierEnabled;
    private final StateMachineModelVerifier<S, E> verifier;
    private final AccessDecisionManager transitionSecurityAccessDecisionManager;
    private final AccessDecisionManager eventSecurityAccessDecisionManager;
    private final SecurityRule eventSecurityRule;
    private final SecurityRule transitionSecurityRule;
    private final StateMachineMonitor<S, E> stateMachineMonitor;
    private final List<StateMachineInterceptor<S, E>> interceptors;
    private final RegionExecutionPolicy regionExecutionPolicy;

    public ConfigurationData() {
        this(null, false, null, new ArrayList<StateMachineListener<S, E>>(), false, null, null, null, null, true, new DefaultStateMachineModelVerifier(), null, null, null);
    }

    public ConfigurationData(BeanFactory beanFactory, boolean autoStart, StateMachineEnsemble<S, E> ensemble, List<StateMachineListener<S, E>> listeners, boolean securityEnabled, AccessDecisionManager transitionSecurityAccessDecisionManager, AccessDecisionManager eventSecurityAccessDecisionManager, SecurityRule eventSecurityRule, SecurityRule transitionSecurityRule, boolean verifierEnabled, StateMachineModelVerifier<S, E> verifier, String machineId, StateMachineMonitor<S, E> stateMachineMonitor, List<StateMachineInterceptor<S, E>> interceptors) {
        this(beanFactory, autoStart, ensemble, listeners, securityEnabled, transitionSecurityAccessDecisionManager, eventSecurityAccessDecisionManager, eventSecurityRule, transitionSecurityRule, verifierEnabled, verifier, machineId, stateMachineMonitor, interceptors, null, null, null, null);
    }

    public ConfigurationData(BeanFactory beanFactory, boolean autoStart, StateMachineEnsemble<S, E> ensemble, List<StateMachineListener<S, E>> listeners, boolean securityEnabled, AccessDecisionManager transitionSecurityAccessDecisionManager, AccessDecisionManager eventSecurityAccessDecisionManager, SecurityRule eventSecurityRule, SecurityRule transitionSecurityRule, boolean verifierEnabled, StateMachineModelVerifier<S, E> verifier, String machineId, StateMachineMonitor<S, E> stateMachineMonitor, List<StateMachineInterceptor<S, E>> interceptors, TransitionConflictPolicy transitionConflightPolicy, StateDoActionPolicy stateDoActionPolicy, Long stateDoActionPolicyTimeout, RegionExecutionPolicy regionExecutionPolicy) {
        this.beanFactory = beanFactory;
        this.autoStart = autoStart;
        this.ensemble = ensemble;
        this.listeners = listeners;
        this.securityEnabled = securityEnabled;
        this.transitionSecurityAccessDecisionManager = transitionSecurityAccessDecisionManager;
        this.eventSecurityAccessDecisionManager = eventSecurityAccessDecisionManager;
        this.eventSecurityRule = eventSecurityRule;
        this.transitionSecurityRule = transitionSecurityRule;
        this.verifierEnabled = verifierEnabled;
        this.verifier = verifier;
        this.machineId = machineId;
        this.stateMachineMonitor = stateMachineMonitor;
        this.interceptors = interceptors;
        this.transitionConflictPolicy = transitionConflightPolicy;
        this.stateDoActionPolicy = stateDoActionPolicy;
        this.stateDoActionPolicyTimeout = stateDoActionPolicyTimeout;
        this.regionExecutionPolicy = regionExecutionPolicy;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public StateMachineEnsemble<S, E> getStateMachineEnsemble() {
        return this.ensemble;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public List<StateMachineListener<S, E>> getStateMachineListeners() {
        return this.listeners;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public boolean isVerifierEnabled() {
        return this.verifierEnabled;
    }

    public StateMachineModelVerifier<S, E> getVerifier() {
        return this.verifier;
    }

    public StateMachineMonitor<S, E> getStateMachineMonitor() {
        return this.stateMachineMonitor;
    }

    public AccessDecisionManager getTransitionSecurityAccessDecisionManager() {
        return this.transitionSecurityAccessDecisionManager;
    }

    public AccessDecisionManager getEventSecurityAccessDecisionManager() {
        return this.eventSecurityAccessDecisionManager;
    }

    public SecurityRule getEventSecurityRule() {
        return this.eventSecurityRule;
    }

    public SecurityRule getTransitionSecurityRule() {
        return this.transitionSecurityRule;
    }

    public List<StateMachineInterceptor<S, E>> getStateMachineInterceptors() {
        return this.interceptors;
    }

    public TransitionConflictPolicy getTransitionConflictPolicy() {
        return this.transitionConflictPolicy;
    }

    public StateDoActionPolicy getStateDoActionPolicy() {
        return this.stateDoActionPolicy;
    }

    public Long getStateDoActionPolicyTimeout() {
        return this.stateDoActionPolicyTimeout;
    }

    public RegionExecutionPolicy getRegionExecutionPolicy() {
        return this.regionExecutionPolicy;
    }
}

