/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configurers;

import org.springframework.security.access.AccessDecisionManager;
import org.springframework.statemachine.config.builders.StateMachineConfigurationBuilder;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.statemachine.config.configurers.SecurityConfigurer;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.security.SecurityRule;

public class DefaultSecurityConfigurer<S, E>
extends AnnotationConfigurerAdapter<ConfigurationData<S, E>, StateMachineConfigurationConfigurer<S, E>, StateMachineConfigurationBuilder<S, E>>
implements SecurityConfigurer<S, E> {
    private boolean enabled = true;
    private AccessDecisionManager transitionAccessDecisionManager;
    private AccessDecisionManager eventAccessDecisionManager;
    private SecurityRule eventSecurityRule;
    private SecurityRule transitionSecurityRule;

    @Override
    public void configure(StateMachineConfigurationBuilder<S, E> builder) throws Exception {
        if (this.enabled) {
            builder.setSecurityEnabled(true);
            builder.setTransitionSecurityAccessDecisionManager(this.transitionAccessDecisionManager);
            builder.setEventSecurityAccessDecisionManager(this.eventAccessDecisionManager);
            builder.setEventSecurityRule(this.eventSecurityRule);
            builder.setTransitionSecurityRule(this.transitionSecurityRule);
        }
    }

    @Override
    public SecurityConfigurer<S, E> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public SecurityConfigurer<S, E> transitionAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.transitionAccessDecisionManager = accessDecisionManager;
        return this;
    }

    @Override
    public SecurityConfigurer<S, E> eventAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.eventAccessDecisionManager = accessDecisionManager;
        return this;
    }

    @Override
    public SecurityConfigurer<S, E> event(String attributes, SecurityRule.ComparisonType match) {
        if (this.eventSecurityRule == null) {
            this.eventSecurityRule = new SecurityRule();
        }
        this.eventSecurityRule.setAttributes(SecurityRule.commaDelimitedListToSecurityAttributes(attributes));
        return this;
    }

    @Override
    public SecurityConfigurer<S, E> event(String expression) {
        if (this.eventSecurityRule == null) {
            this.eventSecurityRule = new SecurityRule();
        }
        this.eventSecurityRule.setExpression(expression);
        return this;
    }

    @Override
    public SecurityConfigurer<S, E> transition(String attributes, SecurityRule.ComparisonType match) {
        if (this.transitionSecurityRule == null) {
            this.transitionSecurityRule = new SecurityRule();
        }
        this.transitionSecurityRule.setAttributes(SecurityRule.commaDelimitedListToSecurityAttributes(attributes));
        return this;
    }

    @Override
    public SecurityConfigurer<S, E> transition(String expression) {
        if (this.transitionSecurityRule == null) {
            this.transitionSecurityRule = new SecurityRule();
        }
        this.transitionSecurityRule.setExpression(expression);
        return this;
    }
}

