/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.builders;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.statemachine.action.StateDoActionPolicy;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.common.annotation.AbstractConfiguredAnnotationBuilder;
import org.springframework.statemachine.config.common.annotation.ObjectPostProcessor;
import org.springframework.statemachine.config.configurers.ConfigurationConfigurer;
import org.springframework.statemachine.config.configurers.DefaultConfigurationConfigurer;
import org.springframework.statemachine.config.configurers.DefaultDistributedStateMachineConfigurer;
import org.springframework.statemachine.config.configurers.DefaultMonitoringConfigurer;
import org.springframework.statemachine.config.configurers.DefaultPersistenceConfigurer;
import org.springframework.statemachine.config.configurers.DefaultSecurityConfigurer;
import org.springframework.statemachine.config.configurers.DefaultVerifierConfigurer;
import org.springframework.statemachine.config.configurers.DistributedStateMachineConfigurer;
import org.springframework.statemachine.config.configurers.MonitoringConfigurer;
import org.springframework.statemachine.config.configurers.PersistenceConfigurer;
import org.springframework.statemachine.config.configurers.SecurityConfigurer;
import org.springframework.statemachine.config.configurers.VerifierConfigurer;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.config.model.verifier.StateMachineModelVerifier;
import org.springframework.statemachine.ensemble.StateMachineEnsemble;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.monitor.StateMachineMonitor;
import org.springframework.statemachine.persist.StateMachineRuntimePersister;
import org.springframework.statemachine.region.RegionExecutionPolicy;
import org.springframework.statemachine.security.SecurityRule;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.transition.TransitionConflictPolicy;

public class StateMachineConfigurationBuilder<S, E>
extends AbstractConfiguredAnnotationBuilder<ConfigurationData<S, E>, StateMachineConfigurationConfigurer<S, E>, StateMachineConfigurationBuilder<S, E>>
implements StateMachineConfigurationConfigurer<S, E> {
    private String machineId;
    private BeanFactory beanFactory;
    private boolean autoStart = false;
    private TransitionConflictPolicy transitionConflictPolicy;
    private StateDoActionPolicy stateDoActionPolicy;
    private Long stateDoActionPolicyTimeout;
    private RegionExecutionPolicy regionExecutionPolicy;
    private StateMachineEnsemble<S, E> ensemble;
    private final List<StateMachineListener<S, E>> listeners = new ArrayList<StateMachineListener<S, E>>();
    private boolean securityEnabled = false;
    private boolean verifierEnabled = true;
    private StateMachineModelVerifier<S, E> verifier;
    private AccessDecisionManager transitionSecurityAccessDecisionManager;
    private AccessDecisionManager eventSecurityAccessDecisionManager;
    private SecurityRule eventSecurityRule;
    private SecurityRule transitionSecurityRule;
    private StateMachineMonitor<S, E> stateMachineMonitor;
    private final List<StateMachineInterceptor<S, E>> interceptors = new ArrayList<StateMachineInterceptor<S, E>>();
    private StateMachineRuntimePersister<S, E, ?> persister;

    public StateMachineConfigurationBuilder() {
    }

    public StateMachineConfigurationBuilder(ObjectPostProcessor<Object> objectPostProcessor, boolean allowConfigurersOfSameType) {
        super(objectPostProcessor, allowConfigurersOfSameType);
    }

    public StateMachineConfigurationBuilder(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    @Override
    public ConfigurationConfigurer<S, E> withConfiguration() throws Exception {
        return this.apply(new DefaultConfigurationConfigurer());
    }

    @Override
    public DistributedStateMachineConfigurer<S, E> withDistributed() throws Exception {
        return this.apply(new DefaultDistributedStateMachineConfigurer());
    }

    @Override
    public SecurityConfigurer<S, E> withSecurity() throws Exception {
        return this.apply(new DefaultSecurityConfigurer());
    }

    @Override
    public VerifierConfigurer<S, E> withVerifier() throws Exception {
        return this.apply(new DefaultVerifierConfigurer());
    }

    @Override
    public MonitoringConfigurer<S, E> withMonitoring() throws Exception {
        return this.apply(new DefaultMonitoringConfigurer());
    }

    @Override
    public PersistenceConfigurer<S, E> withPersistence() throws Exception {
        return this.apply(new DefaultPersistenceConfigurer());
    }

    @Override
    protected ConfigurationData<S, E> performBuild() throws Exception {
        StateMachineInterceptor<S, E> interceptor;
        ArrayList<StateMachineInterceptor<S, StateMachineInterceptor<S, E>>> interceptorsCopy = new ArrayList<StateMachineInterceptor<S, StateMachineInterceptor<S, E>>>(this.interceptors);
        if (this.persister != null && (interceptor = this.persister.getInterceptor()) != null) {
            interceptorsCopy.add(interceptor);
        }
        return new ConfigurationData<S, E>(this.beanFactory, this.autoStart, this.ensemble, this.listeners, this.securityEnabled, this.transitionSecurityAccessDecisionManager, this.eventSecurityAccessDecisionManager, this.eventSecurityRule, this.transitionSecurityRule, this.verifierEnabled, this.verifier, this.machineId, this.stateMachineMonitor, interceptorsCopy, this.transitionConflictPolicy, this.stateDoActionPolicy, this.stateDoActionPolicyTimeout, this.regionExecutionPolicy);
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setStateMachineEnsemble(StateMachineEnsemble<S, E> ensemble) {
        this.ensemble = ensemble;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setStateMachineListeners(List<StateMachineListener<S, E>> listeners) {
        this.listeners.clear();
        this.listeners.addAll(listeners);
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public void setVerifierEnabled(boolean verifierEnabled) {
        this.verifierEnabled = verifierEnabled;
    }

    public void setStateMachineMonitor(StateMachineMonitor<S, E> stateMachineMonitor) {
        this.stateMachineMonitor = stateMachineMonitor;
    }

    public void setTransitionSecurityAccessDecisionManager(AccessDecisionManager transitionSecurityAccessDecisionManager) {
        this.transitionSecurityAccessDecisionManager = transitionSecurityAccessDecisionManager;
    }

    public void setEventSecurityAccessDecisionManager(AccessDecisionManager eventSecurityAccessDecisionManager) {
        this.eventSecurityAccessDecisionManager = eventSecurityAccessDecisionManager;
    }

    public void setEventSecurityRule(SecurityRule eventSecurityRule) {
        this.eventSecurityRule = eventSecurityRule;
    }

    public void setTransitionSecurityRule(SecurityRule transitionSecurityRule) {
        this.transitionSecurityRule = transitionSecurityRule;
    }

    public void setVerifier(StateMachineModelVerifier<S, E> verifier) {
        this.verifier = verifier;
    }

    public void setStateMachineRuntimePersister(StateMachineRuntimePersister<S, E, ?> persister) {
        this.persister = persister;
    }

    public void setTransitionConflictPolicy(TransitionConflictPolicy transitionConflictPolicy) {
        this.transitionConflictPolicy = transitionConflictPolicy;
    }

    public void setStateDoActionPolicy(StateDoActionPolicy stateDoActionPolicy, Long stateDoActionPolicyTimeout) {
        this.stateDoActionPolicy = stateDoActionPolicy;
        this.stateDoActionPolicyTimeout = stateDoActionPolicyTimeout;
    }

    public void setRegionExecutionPolicy(RegionExecutionPolicy regionExecutionPolicy) {
        this.regionExecutionPolicy = regionExecutionPolicy;
    }
}

