/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.ensemble.StateMachineEnsemble;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DistributedLeaderAction<S, E>
implements Action<S, E> {
    private static final Log log = LogFactory.getLog(DistributedLeaderAction.class);
    private final Action<S, E> action;
    private final StateMachineEnsemble<S, E> ensemble;

    public DistributedLeaderAction(Action<S, E> action, StateMachineEnsemble<S, E> ensemble) {
        Assert.notNull(action, (String)"Action must be set");
        Assert.notNull(ensemble, (String)"Ensemble must be set");
        this.action = action;
        this.ensemble = ensemble;
    }

    @Override
    public void execute(StateContext<S, E> context) {
        boolean leader;
        StateMachine<S, E> left = context.getStateMachine();
        StateMachine<S, E> right = this.ensemble.getLeader();
        boolean bl = leader = left != null & right != null && ObjectUtils.nullSafeEquals((Object)left.getUuid(), (Object)right.getUuid());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Distibuted action leader status is " + leader));
        }
        if (leader) {
            this.action.execute(context);
        }
    }
}

