/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine;

import java.util.Collection;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;

public interface StateContext<S, E> {
    public Stage getStage();

    public Message<E> getMessage();

    public E getEvent();

    public MessageHeaders getMessageHeaders();

    public Object getMessageHeader(Object var1);

    public ExtendedState getExtendedState();

    public Transition<S, E> getTransition();

    public StateMachine<S, E> getStateMachine();

    public State<S, E> getSource();

    public Collection<State<S, E>> getSources();

    public State<S, E> getTarget();

    public Collection<State<S, E>> getTargets();

    public Exception getException();

    public static enum Stage {
        EVENT_NOT_ACCEPTED,
        EXTENDED_STATE_CHANGED,
        STATE_CHANGED,
        STATE_ENTRY,
        STATE_EXIT,
        STATEMACHINE_ERROR,
        STATEMACHINE_START,
        STATEMACHINE_STOP,
        TRANSITION,
        TRANSITION_START,
        TRANSITION_END;

    }
}

