/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.springframework.kafka.listener.adapter.AbstractMessageListenerAdapter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public abstract class AbstractRetryingMessageListenerAdapter<K, V, T>
extends AbstractMessageListenerAdapter<K, V, T> {
    private final RetryTemplate retryTemplate;
    private final RecoveryCallback<Void> recoveryCallback;

    public AbstractRetryingMessageListenerAdapter(T delegate, RetryTemplate retryTemplate) {
        this(delegate, retryTemplate, null);
    }

    public AbstractRetryingMessageListenerAdapter(T delegate, RetryTemplate retryTemplate, RecoveryCallback<Void> recoveryCallback) {
        super(delegate);
        Assert.notNull((Object)retryTemplate, (String)"'retryTemplate' cannot be null");
        this.retryTemplate = retryTemplate;
        this.recoveryCallback = recoveryCallback;
    }

    public RetryTemplate getRetryTemplate() {
        return this.retryTemplate;
    }

    public RecoveryCallback<Void> getRecoveryCallback() {
        return this.recoveryCallback;
    }
}

