/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class LambdaMessageProcessor
implements MessageProcessor<Object>,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(LambdaMessageProcessor.class);
    private final Object target;
    private final Method method;
    private final Class<?> payloadType;
    private final Class<?>[] parameterTypes;
    private MessageConverter messageConverter;

    public LambdaMessageProcessor(Object target, Class<?> payloadType) {
        Assert.notNull((Object)target, (String)"'target' must not be null");
        this.target = target;
        AtomicReference methodValue = new AtomicReference();
        ReflectionUtils.doWithMethods(target.getClass(), methodValue::set, methodCandidate -> {
            boolean isCandidate;
            boolean bl = isCandidate = !methodCandidate.isBridge() && !methodCandidate.isDefault() && methodCandidate.getDeclaringClass() != Object.class && Modifier.isPublic(methodCandidate.getModifiers()) && !Modifier.isStatic(methodCandidate.getModifiers());
            if (isCandidate) {
                Assert.isNull(methodValue.get(), (String)"LambdaMessageProcessor is applicable for inline or lambda classes with single method - functional interface implementations.");
            }
            return isCandidate;
        });
        Assert.notNull(methodValue.get(), (String)"LambdaMessageProcessor is applicable for inline or lambda classes with single method - functional interface implementations.");
        this.method = (Method)methodValue.get();
        this.method.setAccessible(true);
        this.parameterTypes = this.method.getParameterTypes();
        this.payloadType = payloadType;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.messageConverter = (MessageConverter)beanFactory.getBean("integrationArgumentResolverMessageConverter", MessageConverter.class);
    }

    @Override
    public Object processMessage(Message<?> message) {
        Object[] args = this.buildArgs(message);
        try {
            return this.method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ClassCastException) {
                logger.error((Object)"Could not invoke the method due to a class cast exception, if using a lambda in the DSL, consider using an overloaded EIP method that takes a Class<?> argument to explicitly specify the type. An example of when this often occurs is if the lambda is configured to receive a Message<?> argument.", e.getCause());
            }
            throw new MessageHandlingException(message, e.getCause());
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, (Throwable)e);
        }
    }

    private Object[] buildArgs(Message<?> message) {
        Object[] args = new Object[this.parameterTypes.length];
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            Class<?> parameterType = this.parameterTypes[i];
            if (Message.class.isAssignableFrom(parameterType)) {
                args[i] = message;
                continue;
            }
            if (Map.class.isAssignableFrom(parameterType)) {
                if (message.getPayload() instanceof Map && this.parameterTypes.length == 1) {
                    args[i] = message.getPayload();
                    continue;
                }
                args[i] = message.getHeaders();
                continue;
            }
            if (this.payloadType != null && !ClassUtils.isAssignable(this.payloadType, message.getPayload().getClass())) {
                if (Message.class.isAssignableFrom(this.payloadType)) {
                    args[i] = message;
                    continue;
                }
                args[i] = this.messageConverter.fromMessage(message, this.payloadType);
                continue;
            }
            args[i] = message.getPayload();
        }
        return args;
    }
}

