/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.qianfan;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.qianfan.QianFanChatOptions;
import org.springaicommunity.qianfan.api.QianFanApi;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class QianFanChatModel
implements ChatModel,
StreamingChatModel {
    private static final Logger logger = LoggerFactory.getLogger(QianFanChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    public final RetryTemplate retryTemplate;
    private final QianFanChatOptions defaultOptions;
    private final QianFanApi qianFanApi;
    private final ObservationRegistry observationRegistry;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public QianFanChatModel(QianFanApi qianFanApi) {
        this(qianFanApi, QianFanChatOptions.builder().model(QianFanApi.DEFAULT_CHAT_MODEL).temperature(0.7).build());
    }

    public QianFanChatModel(QianFanApi qianFanApi, QianFanChatOptions options) {
        this(qianFanApi, options, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public QianFanChatModel(QianFanApi qianFanApi, QianFanChatOptions options, RetryTemplate retryTemplate) {
        this(qianFanApi, options, retryTemplate, ObservationRegistry.NOOP);
    }

    public QianFanChatModel(QianFanApi qianFanApi, QianFanChatOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)qianFanApi, (String)"QianFanApi must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.qianFanApi = qianFanApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public ChatResponse call(Prompt prompt) {
        QianFanApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider("qianfan").build();
        return (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.qianFanApi.chatCompletionEntity(request));
            QianFanApi.ChatCompletion chatCompletion = (QianFanApi.ChatCompletion)completionEntity.getBody();
            if (chatCompletion == null) {
                logger.warn("No chat completion returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            Map<String, QianFanApi.ChatCompletionMessage.Role> metadata = Map.of("id", chatCompletion.id(), "role", QianFanApi.ChatCompletionMessage.Role.ASSISTANT);
            AssistantMessage assistantMessage = new AssistantMessage(chatCompletion.result(), metadata);
            List<Generation> generations = Collections.singletonList(new Generation(assistantMessage));
            ChatResponse chatResponse = new ChatResponse(generations, this.from(chatCompletion, request.model()));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return Flux.deferContextual(contextView -> {
            QianFanApi.ChatCompletionRequest request = this.createRequest(prompt, true);
            Flux<QianFanApi.ChatCompletionChunk> completionChunks = this.qianFanApi.chatCompletionStream(request);
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider("qianfan").build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux chatResponse = completionChunks.map(this::toChatCompletion).switchMap(chatCompletion -> Mono.just((Object)chatCompletion).map(chatCompletion2 -> {
                Map<String, QianFanApi.ChatCompletionMessage.Role> metadata = Map.of("id", chatCompletion.id(), "role", QianFanApi.ChatCompletionMessage.Role.ASSISTANT);
                AssistantMessage assistantMessage = new AssistantMessage(chatCompletion.result(), metadata);
                List<Generation> generations = Collections.singletonList(new Generation(assistantMessage));
                return new ChatResponse(generations, this.from((QianFanApi.ChatCompletion)chatCompletion, request.model()));
            })).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(chatResponse, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private QianFanApi.ChatCompletion toChatCompletion(QianFanApi.ChatCompletionChunk chunk) {
        return new QianFanApi.ChatCompletion(chunk.id(), chunk.object(), chunk.created(), chunk.result(), chunk.finishReason(), chunk.usage());
    }

    public QianFanApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        List<QianFanApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(m -> new QianFanApi.ChatCompletionMessage(m.getText(), QianFanApi.ChatCompletionMessage.Role.valueOf(m.getMessageType().name()))).toList();
        List<QianFanApi.ChatCompletionMessage> systemMessageList = chatCompletionMessages.stream().filter(msg -> msg.role() == QianFanApi.ChatCompletionMessage.Role.SYSTEM).toList();
        List<QianFanApi.ChatCompletionMessage> userMessageList = chatCompletionMessages.stream().filter(msg -> msg.role() != QianFanApi.ChatCompletionMessage.Role.SYSTEM).toList();
        if (systemMessageList.size() > 1) {
            throw new IllegalArgumentException("Only one system message is allowed in the prompt");
        }
        String systemMessage = systemMessageList.isEmpty() ? null : systemMessageList.get(0).content();
        QianFanApi.ChatCompletionRequest request = new QianFanApi.ChatCompletionRequest(userMessageList, systemMessage, stream);
        if (this.defaultOptions != null) {
            request = (QianFanApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)this.defaultOptions, (Object)request, QianFanApi.ChatCompletionRequest.class);
        }
        if (prompt.getOptions() != null) {
            QianFanChatOptions updatedRuntimeOptions = (QianFanChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, QianFanChatOptions.class);
            request = (QianFanApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, QianFanApi.ChatCompletionRequest.class);
        }
        return request;
    }

    public ChatOptions getDefaultOptions() {
        return QianFanChatOptions.fromOptions(this.defaultOptions);
    }

    private ChatOptions buildRequestOptions(QianFanApi.ChatCompletionRequest request) {
        return ChatOptions.builder().model(request.model()).frequencyPenalty(request.frequencyPenalty()).maxTokens(request.maxTokens()).presencePenalty(request.presencePenalty()).stopSequences(request.stop()).temperature(request.temperature()).topP(request.topP()).build();
    }

    private ChatResponseMetadata from(QianFanApi.ChatCompletion result, String model) {
        Assert.notNull((Object)result, (String)"QianFan ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.id() != null ? result.id() : "").usage((Usage)(result.usage() != null ? this.getDefaultUsage(result.usage()) : new EmptyUsage())).model(model).keyValue("created", (Object)(result.created() != null ? result.created() : 0L)).build();
    }

    private DefaultUsage getDefaultUsage(QianFanApi.Usage usage) {
        return new DefaultUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens(), (Object)usage);
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }
}

