/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.moonshot.api;

import java.util.ArrayList;
import java.util.List;
import org.springaicommunity.moonshot.api.MoonshotApi;
import org.springframework.util.CollectionUtils;

public class MoonshotStreamFunctionCallingHelper {
    public MoonshotApi.ChatCompletionChunk merge(MoonshotApi.ChatCompletionChunk previous, MoonshotApi.ChatCompletionChunk current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        Long created = current.created() != null ? current.created() : previous.created();
        String model = current.model() != null ? current.model() : previous.model();
        String object = current.object() != null ? current.object() : previous.object();
        MoonshotApi.ChatCompletionChunk.ChunkChoice previousChoice0 = CollectionUtils.isEmpty(previous.choices()) ? null : previous.choices().get(0);
        MoonshotApi.ChatCompletionChunk.ChunkChoice currentChoice0 = CollectionUtils.isEmpty(current.choices()) ? null : current.choices().get(0);
        MoonshotApi.ChatCompletionChunk.ChunkChoice choice = this.merge(previousChoice0, currentChoice0);
        List<MoonshotApi.ChatCompletionChunk.ChunkChoice> chunkChoices = choice == null ? List.of() : List.of(choice);
        return new MoonshotApi.ChatCompletionChunk(id, object, created, model, chunkChoices);
    }

    private MoonshotApi.ChatCompletionChunk.ChunkChoice merge(MoonshotApi.ChatCompletionChunk.ChunkChoice previous, MoonshotApi.ChatCompletionChunk.ChunkChoice current) {
        if (previous == null) {
            return current;
        }
        MoonshotApi.ChatCompletionFinishReason finishReason = current.finishReason() != null ? current.finishReason() : previous.finishReason();
        Integer index = current.index() != null ? current.index() : previous.index();
        MoonshotApi.Usage usage = current.usage() != null ? current.usage() : previous.usage();
        MoonshotApi.ChatCompletionMessage message = this.merge(previous.delta(), current.delta());
        return new MoonshotApi.ChatCompletionChunk.ChunkChoice(index, message, finishReason, usage);
    }

    private MoonshotApi.ChatCompletionMessage merge(MoonshotApi.ChatCompletionMessage previous, MoonshotApi.ChatCompletionMessage current) {
        String content = current.content() != null ? current.content() : (previous.content() != null ? previous.content() : "");
        MoonshotApi.ChatCompletionMessage.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : MoonshotApi.ChatCompletionMessage.Role.ASSISTANT;
        String name = current.name() != null ? current.name() : previous.name();
        String toolCallId = current.toolCallId() != null ? current.toolCallId() : previous.toolCallId();
        ArrayList<MoonshotApi.ChatCompletionMessage.ToolCall> toolCalls = new ArrayList<MoonshotApi.ChatCompletionMessage.ToolCall>();
        MoonshotApi.ChatCompletionMessage.ToolCall lastPreviousTooCall = null;
        if (previous.toolCalls() != null) {
            lastPreviousTooCall = previous.toolCalls().get(previous.toolCalls().size() - 1);
            if (previous.toolCalls().size() > 1) {
                toolCalls.addAll(previous.toolCalls().subList(0, previous.toolCalls().size() - 1));
            }
        }
        if (current.toolCalls() != null) {
            if (current.toolCalls().size() > 1) {
                throw new IllegalStateException("Currently only one tool call is supported per message!");
            }
            MoonshotApi.ChatCompletionMessage.ToolCall currentToolCall = current.toolCalls().iterator().next();
            if (currentToolCall.id() != null) {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(currentToolCall);
            } else {
                toolCalls.add(this.merge(lastPreviousTooCall, currentToolCall));
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return new MoonshotApi.ChatCompletionMessage(content, role, name, toolCallId, toolCalls);
    }

    private MoonshotApi.ChatCompletionMessage.ToolCall merge(MoonshotApi.ChatCompletionMessage.ToolCall previous, MoonshotApi.ChatCompletionMessage.ToolCall current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        String type = current.type() != null ? current.type() : previous.type();
        MoonshotApi.ChatCompletionMessage.ChatCompletionFunction function = this.merge(previous.function(), current.function());
        return new MoonshotApi.ChatCompletionMessage.ToolCall(id, type, function);
    }

    private MoonshotApi.ChatCompletionMessage.ChatCompletionFunction merge(MoonshotApi.ChatCompletionMessage.ChatCompletionFunction previous, MoonshotApi.ChatCompletionMessage.ChatCompletionFunction current) {
        if (previous == null) {
            return current;
        }
        String name = current.name() != null ? current.name() : previous.name();
        StringBuilder arguments = new StringBuilder();
        if (previous.arguments() != null) {
            arguments.append(previous.arguments());
        }
        if (current.arguments() != null) {
            arguments.append(current.arguments());
        }
        return new MoonshotApi.ChatCompletionMessage.ChatCompletionFunction(name, arguments.toString());
    }

    public boolean isStreamingToolFunctionCall(MoonshotApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        MoonshotApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(choice.delta().toolCalls());
    }

    public boolean isStreamingToolFunctionCallFinish(MoonshotApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        MoonshotApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return choice.finishReason() == MoonshotApi.ChatCompletionFinishReason.TOOL_CALLS;
    }
}

