/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileEntryIterator
implements Iterator<String> {
    private final String rootPath;
    private final LinkedList<String> entryNames = new LinkedList();
    private final boolean recurse;

    FileEntryIterator(URL url, String subPath, boolean recurse) {
        this.rootPath = FileEntryIterator.normalizePath(FileEntryIterator.toFile(url).getAbsoluteFile());
        this.recurse = recurse;
        this.appendEntries(subPath);
    }

    @Override
    public boolean hasNext() {
        return this.entryNames.size() > 0;
    }

    @Override
    public String next() {
        String name = this.entryNames.removeFirst();
        if (this.recurse && name.endsWith("/")) {
            this.appendEntries(name);
        }
        return name;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static File toFile(URL url) {
        StringBuilder buf = new StringBuilder();
        String path = url.getPath();
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            char c = path.charAt(i);
            if ('/' == c) {
                buf.append(File.separatorChar);
                continue;
            }
            if ('%' == c && i < length - 2) {
                buf.append((char)Integer.parseInt(path.substring(++i, ++i + 1), 16));
                continue;
            }
            buf.append(c);
        }
        return new File(buf.toString());
    }

    private void appendEntries(String subPath) {
        File[] listing = new File(this.rootPath + subPath).listFiles();
        if (null != listing) {
            for (File f : listing) {
                this.entryNames.add(FileEntryIterator.normalizePath(f).substring(this.rootPath.length()));
            }
        }
    }

    private static String normalizePath(File file) {
        return file.toURI().getPath();
    }
}

