/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.components.cipher;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.plexus.components.cipher.PBECipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

public class DefaultPlexusCipher
extends AbstractLogEnabled
implements PlexusCipher {
    private static final int SALT_SIZE = 8;
    private static final String STRING_ENCODING = "UTF8";
    private PBECipher _cipher = new PBECipher();

    public String encrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this._cipher.encrypt64(str, passPhrase);
    }

    public String encryptAndDecorate(String str, String passPhrase) throws PlexusCipherException {
        return this.decorate(this.encrypt(str, passPhrase));
    }

    public String decrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this._cipher.decrypt64(str, passPhrase);
    }

    public String decryptDecorated(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        if (this.isEncryptedString(str)) {
            return this.decrypt(this.unDecorate(str), passPhrase);
        }
        return this.decrypt(str, passPhrase);
    }

    public boolean isEncryptedString(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        int start = str.indexOf(123);
        int stop = str.indexOf(125);
        return start != -1 && stop != -1 && stop > start + 1;
    }

    public String unDecorate(String str) throws PlexusCipherException {
        if (!this.isEncryptedString(str)) {
            throw new PlexusCipherException("default.plexus.cipher.badEncryptedPassword");
        }
        int start = str.indexOf(123);
        int stop = str.indexOf(125);
        return str.substring(start + 1, stop);
    }

    public String decorate(String str) {
        return '{' + (str == null ? "" : str) + '}';
    }

    public static String[] getServiceTypes() {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            Iterator<Object> it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if ((key = key.split(" ")[0]).startsWith("Alg.Alias.")) {
                    key = key.substring(10);
                }
                int ix = key.indexOf(46);
                result.add(key.substring(0, ix));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getCryptoImpls(String serviceType) {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            Iterator<Object> it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if ((key = key.split(" ")[0]).startsWith(serviceType + ".")) {
                    result.add(key.substring(serviceType.length() + 1));
                    continue;
                }
                if (!key.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result.add(key.substring(serviceType.length() + 11));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        String[] serviceTypes = DefaultPlexusCipher.getServiceTypes();
        if (serviceTypes != null) {
            for (int i = 0; i < serviceTypes.length; ++i) {
                String serviceType = serviceTypes[i];
                String[] serviceProviders = DefaultPlexusCipher.getCryptoImpls(serviceType);
                if (serviceProviders != null) {
                    System.out.println(serviceType + ": provider list");
                    for (int j = 0; j < serviceProviders.length; ++j) {
                        String provider = serviceProviders[j];
                        System.out.println("        " + provider);
                    }
                    continue;
                }
                System.out.println(serviceType + ": does not have any providers in this environment");
            }
        }
    }
}

