/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.deffer;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.plugin.deffer.ArtifactDeferrer;
import org.sonatype.central.publisher.plugin.model.ArtifactWithFile;
import org.sonatype.central.publisher.plugin.model.DeferArtifactRequest;

@Component(role=ArtifactDeferrer.class)
public class ArtifactDeferrerImpl
extends AbstractLogEnabled
implements ArtifactDeferrer {
    public static final String INDEX_FILE_NAME = ".index";
    protected static final Pattern INDEX_PROPS = Pattern.compile("([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):(.*)");
    protected static final String INDEX_LINE_FORMAT = "%s=%s:%s:%s:%s:%s:%s:%s:%s:%s:%s";
    private static final Object PARALLEL_LOCK = new Object();
    @Requirement
    private final ArtifactRepositoryFactory artifactRepositoryFactory;
    @Requirement
    private final ArtifactRepositoryLayout artifactRepositoryLayout;
    @Requirement
    private final ArtifactInstaller artifactInstaller;
    @Requirement
    private final ArtifactDeployer artifactDeployer;

    @Inject
    public ArtifactDeferrerImpl(ArtifactRepositoryFactory artifactRepositoryFactory, ArtifactRepositoryLayout artifactRepositoryLayout, ArtifactInstaller artifactInstaller, ArtifactDeployer artifactDeployer) {
        this.artifactRepositoryFactory = artifactRepositoryFactory;
        this.artifactRepositoryLayout = artifactRepositoryLayout;
        this.artifactInstaller = artifactInstaller;
        this.artifactDeployer = artifactDeployer;
    }

    @Override
    public void install(DeferArtifactRequest request) throws ArtifactInstallationException, MojoExecutionException {
        List<ArtifactWithFile> artifactWithFiles = request.getArtifactWithFiles();
        if (null != artifactWithFiles && !artifactWithFiles.isEmpty()) {
            for (ArtifactWithFile artifactWithFile : artifactWithFiles) {
                File stagingDirectory = request.getDeferredDirectory();
                ArtifactRepository stagingRepository = this.getArtifactRepositoryForDirectory(stagingDirectory);
                ArtifactRepository deploymentRepository = this.getDeploymentRepository(request.getMavenSession(), request.getCentralSnapshotsUrl(), request.getServerId());
                this.install(artifactWithFile.getFile(), artifactWithFile.getArtifact(), stagingRepository, stagingDirectory, deploymentRepository);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(File source, Artifact artifact, ArtifactRepository stagingRepository, File stagingDirectory, ArtifactRepository remoteRepository) throws ArtifactInstallationException {
        Object object = PARALLEL_LOCK;
        synchronized (object) {
            String path = stagingRepository.pathOf(artifact);
            try {
                Optional.ofNullable(this.getLogger()).ifPresent(logger -> logger.debug(String.format("Installing artifact %s into staging repository\n%s", artifact, stagingRepository)));
                this.artifactInstaller.install(source, artifact, stagingRepository);
                String pluginPrefix = null;
                for (ArtifactMetadata artifactMetadata : artifact.getMetadataList()) {
                    if (!(artifactMetadata instanceof GroupRepositoryMetadata)) continue;
                    Plugin plugin = (Plugin)((GroupRepositoryMetadata)artifactMetadata).getMetadata().getPlugins().get(0);
                    pluginPrefix = plugin.getPrefix();
                }
                try (FileOutputStream fos = new FileOutputStream(new File(stagingDirectory, INDEX_FILE_NAME), true);
                     OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.ISO_8859_1);
                     PrintWriter pw = new PrintWriter(osw);){
                    String pomFileName = null;
                    for (ArtifactMetadata artifactMetadata : artifact.getMetadataList()) {
                        if (!(artifactMetadata instanceof ProjectArtifactMetadata)) continue;
                        pomFileName = artifactMetadata.getLocalFilename(stagingRepository);
                    }
                    pw.println(String.format(INDEX_LINE_FORMAT, path, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), StringUtils.isBlank((CharSequence)artifact.getClassifier()) ? "n/a" : artifact.getClassifier(), artifact.getType(), artifact.getArtifactHandler() == null ? "n/a" : artifact.getArtifactHandler().getExtension(), StringUtils.isBlank((CharSequence)pomFileName) ? "n/a" : pomFileName, StringUtils.isBlank((CharSequence)pluginPrefix) ? "n/a" : pluginPrefix, remoteRepository != null ? remoteRepository.getId() : "n/a", remoteRepository != null ? remoteRepository.getUrl() : "n/a"));
                    pw.flush();
                }
            }
            catch (IOException e) {
                throw new ArtifactInstallationException("Cannot locally stage and maintain the index file!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployUp(MavenSession mavenSession, File sourceDirectory, ArtifactRepository remoteRepository) throws ArtifactDeploymentException, IOException {
        FileInputStream fis = new FileInputStream(new File(sourceDirectory, INDEX_FILE_NAME));
        Properties index = new Properties();
        try {
            index.load(fis);
        }
        finally {
            Closeables.closeQuietly((InputStream)fis);
        }
        ArtifactRepository repoToUse = remoteRepository;
        for (String includedFilePath : index.stringPropertyNames()) {
            String repoUrl;
            File includedFile = new File(sourceDirectory, includedFilePath);
            String includedFileProps = index.getProperty(includedFilePath);
            Matcher matcher = INDEX_PROPS.matcher(includedFileProps);
            if (!matcher.matches()) {
                throw new ArtifactDeploymentException(String.format("Internal error! Line \"%s\" does not match pattern \"%s\"?", includedFileProps, INDEX_PROPS));
            }
            String groupId = matcher.group(1);
            String artifactId = matcher.group(2);
            String version = matcher.group(3);
            String classifier = "n/a".equals(matcher.group(4)) ? null : matcher.group(4);
            String packaging = matcher.group(5);
            String extension = matcher.group(6);
            String pomFileName = "n/a".equals(matcher.group(7)) ? null : matcher.group(7);
            String pluginPrefix = "n/a".equals(matcher.group(8)) ? null : matcher.group(8);
            String repoId = "n/a".equals(matcher.group(9)) ? null : matcher.group(9);
            String string = repoUrl = "n/a".equals(matcher.group(10)) ? null : matcher.group(10);
            if (remoteRepository == null) {
                if (repoUrl != null && repoId != null) {
                    repoToUse = this.createDeploymentArtifactRepository(repoId, repoUrl);
                } else {
                    throw new ArtifactDeploymentException("Internal error! Remote repository for deployment not defined.");
                }
            }
            FakeArtifactHandler artifactHandler = new FakeArtifactHandler(packaging, extension);
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), null, packaging, classifier, (ArtifactHandler)artifactHandler);
            if (pomFileName != null) {
                this.addPomMetaData(includedFile, pomFileName, artifact);
                this.maybeAddMavenPluginMetaData(artifact, groupId, pluginPrefix, artifactId);
            }
            Optional.ofNullable(this.getLogger()).ifPresent(logger -> logger.debug(String.format("Deploying: %s:%s:%s:%s:%s:%s - file %s:%s: to server id: %s: url: %s", groupId, artifactId, version, classifier, packaging, extension, pomFileName, pluginPrefix, repoId, repoUrl)));
            this.artifactDeployer.deploy(includedFile, (Artifact)artifact, repoToUse, mavenSession.getLocalRepository());
        }
    }

    protected ArtifactRepository getArtifactRepositoryForDirectory(File stagingDirectory) throws MojoExecutionException {
        if (stagingDirectory == null) {
            throw new MojoExecutionException("Staging failed: staging directory is null!");
        }
        try {
            Files.createDirectories(stagingDirectory.toPath(), new FileAttribute[0]);
            String url = stagingDirectory.getCanonicalFile().toURI().toURL().toExternalForm();
            return this.createStagingArtifactRepository(url);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Staging failed: could not create ArtifactRepository in staging directory " + stagingDirectory, (Exception)e);
        }
    }

    protected ArtifactRepository getDeploymentRepository(MavenSession mavenSession, String centralSnapshotsUrl, String publishingServerId) throws MojoExecutionException {
        if (StringUtils.isNotBlank((CharSequence)publishingServerId) && StringUtils.isNotBlank((CharSequence)centralSnapshotsUrl)) {
            return this.createDeploymentArtifactRepository(publishingServerId, centralSnapshotsUrl);
        }
        if (null == mavenSession) {
            throw new MojoExecutionException("Deployment failed, missing maven session.");
        }
        ArtifactRepository repo = mavenSession.getCurrentProject().getDistributionManagementArtifactRepository();
        if (null == repo) {
            if (StringUtils.isNotBlank((CharSequence)publishingServerId)) {
                return this.createDeploymentArtifactRepository(publishingServerId, "https://central.sonatype.com/repository/maven-snapshots/");
            }
            String msg = "Deployment failed, missing snapshots url:\ncentralSnapshotsUrl element was not specified in the inside configuration element\nor the repository element was not specified in the POM inside distributionManagement element";
            throw new MojoExecutionException(msg);
        }
        if (StringUtils.isBlank((CharSequence)repo.getId())) {
            String msg = "Deployment failed, missing server id:\nrepository element was specified in the POM inside distributionManagement element but is missing element id";
            throw new MojoExecutionException(msg);
        }
        if (StringUtils.isBlank((CharSequence)repo.getUrl())) {
            String msg = "Deployment failed, missing snapshots url:\nrepository element was specified in the POM inside distributionManagement element but is missing element url";
            throw new MojoExecutionException(msg);
        }
        return repo;
    }

    protected ArtifactRepository createStagingArtifactRepository(String url) {
        return this.createDeploymentArtifactRepository("central-staging", url);
    }

    protected ArtifactRepository createDeploymentArtifactRepository(String id, String url) {
        return this.artifactRepositoryFactory.createDeploymentArtifactRepository(id, url, this.artifactRepositoryLayout, true);
    }

    private void addPomMetaData(File includedFile, String pomFileName, DefaultArtifact artifact) {
        File pomFile = new File(includedFile.getParentFile(), pomFileName);
        ProjectArtifactMetadata pom = new ProjectArtifactMetadata((Artifact)artifact, pomFile);
        artifact.addMetadata((ArtifactMetadata)pom);
    }

    private void maybeAddMavenPluginMetaData(DefaultArtifact artifact, String groupId, String pluginPrefix, String artifactId) {
        if ("maven-plugin".equals(artifact.getType())) {
            artifact.addMetadata((ArtifactMetadata)ArtifactDeferrerImpl.getGroupRepositoryMetadata(groupId, pluginPrefix, artifactId));
        }
    }

    private static GroupRepositoryMetadata getGroupRepositoryMetadata(String groupId, String pluginPrefix, String artifactId) {
        GroupRepositoryMetadata groupMetadata = new GroupRepositoryMetadata(groupId);
        groupMetadata.addPluginMapping(pluginPrefix, artifactId, artifactId);
        return groupMetadata;
    }

    public static class FakeArtifactHandler
    extends DefaultArtifactHandler {
        private final String extension;

        public FakeArtifactHandler(String type, String extension) {
            super((String)Preconditions.checkNotNull((Object)type));
            this.extension = (String)Preconditions.checkNotNull((Object)extension);
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

