/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.sonatype.central.publisher.client.PublisherClient;
import org.sonatype.central.publisher.client.httpclient.auth.AuthProviderType;
import org.sonatype.central.publisher.client.model.PublishingType;
import org.sonatype.central.publisher.plugin.AbstractPublisherMojo;
import org.sonatype.central.publisher.plugin.bundler.ArtifactBundler;
import org.sonatype.central.publisher.plugin.config.PlexusContextConfig;
import org.sonatype.central.publisher.plugin.deffer.ArtifactDeferrer;
import org.sonatype.central.publisher.plugin.model.ArtifactWithFile;
import org.sonatype.central.publisher.plugin.model.BundleArtifactRequest;
import org.sonatype.central.publisher.plugin.model.ChecksumRequest;
import org.sonatype.central.publisher.plugin.model.DeferArtifactRequest;
import org.sonatype.central.publisher.plugin.model.StageArtifactRequest;
import org.sonatype.central.publisher.plugin.model.UploadArtifactRequest;
import org.sonatype.central.publisher.plugin.model.WaitForDeploymentStateRequest;
import org.sonatype.central.publisher.plugin.model.WaitUntilRequest;
import org.sonatype.central.publisher.plugin.published.ComponentPublishedChecker;
import org.sonatype.central.publisher.plugin.stager.ArtifactStager;
import org.sonatype.central.publisher.plugin.uploader.ArtifactUploader;
import org.sonatype.central.publisher.plugin.utils.AuthData;
import org.sonatype.central.publisher.plugin.watcher.DeploymentPublishedWatcher;

@Mojo(name="publish", defaultPhase=LifecyclePhase.DEPLOY, requiresOnline=true, threadSafe=true)
public class PublishMojo
extends AbstractPublisherMojo {
    @Parameter(property="outputFilename", defaultValue="central-bundle.zip", required=true)
    private String outputFilename;
    @Parameter(property="outputDirectory")
    private File forcedOutputDirectory;
    @Parameter(property="stagingDirectory")
    private File forcedStagingDirectory;
    @Parameter(property="deferredDirectory")
    private File forcedDeferredDirectory;
    @Parameter(property="deploymentName", defaultValue="Deployment")
    private String deploymentName;
    @Parameter(property="publishingServerId", defaultValue="central")
    private String publishingServerId;
    @Parameter(property="autoPublish", defaultValue="false")
    private boolean autoPublish;
    @Parameter(property="waitUntil", defaultValue="VALIDATED")
    private String waitUntil;
    @Parameter(property="waitMaxTime", defaultValue="1800")
    private int waitMaxTime;
    @Parameter(property="waitPollingInterval", defaultValue="5")
    private int waitPollingInterval;
    @Deprecated
    @Parameter(property="publishCompletionPollInterval", defaultValue="1000")
    private int publishCompletionPollInterval;
    @Deprecated
    @Parameter(property="waitForPublishCompletion", defaultValue="false")
    private boolean waitForPublishCompletion;
    @Parameter(property="centralBaseUrl", defaultValue="https://central.sonatype.com")
    private String centralBaseUrl;
    @Parameter(property="centralSnapshotsUrl")
    private String centralSnapshotsUrl;
    @Parameter(property="checksums", defaultValue="ALL")
    private String checksums;
    @Parameter(property="ignorePublishedComponents", defaultValue="false")
    private boolean ignorePublishedComponents;
    @Parameter(property="excludeArtifacts")
    private List<String> excludeArtifacts = new ArrayList<String>();
    @Component
    private PlexusContextConfig plexusContextConfig;
    @Component
    private ArtifactBundler artifactBundler;
    @Component
    private ArtifactStager artifactStager;
    @Component
    private ArtifactDeferrer artifactDeferrer;
    @Component
    private PublisherClient publisherClient;
    @Component
    private ArtifactUploader artifactUploader;
    @Component
    private DeploymentPublishedWatcher deploymentPublishedWatcher;
    @Component
    private ComponentPublishedChecker componentPublishedChecker;
    @Component
    private SettingsDecrypter theCryptKeeper;
    private ChecksumRequest checksumRequest;
    private WaitUntilRequest waitUntilRequest;
    private PublishingType publishingType;

    @Override
    protected void doValidateParameters() throws MojoExecutionException {
        int publishCompletionPollIntervalDefault = Integer.parseInt("1000");
        int waitPollingIntervalDefault = Integer.parseInt("5");
        if (this.publishCompletionPollInterval != publishCompletionPollIntervalDefault) {
            this.getLog().warn((CharSequence)String.format("%s is deprecated, using it will set %s (converted to seconds).", "publishCompletionPollInterval", "waitMaxTime"));
            if (this.waitPollingInterval == waitPollingIntervalDefault) {
                this.waitPollingInterval = this.publishCompletionPollInterval / 1000;
            }
        }
        if (this.waitPollingInterval < waitPollingIntervalDefault) {
            this.getLog().warn((CharSequence)String.format("%s was set to be less then %2$s seconds, will use the default of %2$s seconds.", "waitPollingInterval", "5"));
            this.waitPollingInterval = waitPollingIntervalDefault;
        }
        int waitMaxTimeDefault = Integer.parseInt("1800");
        if (this.waitMaxTime < Integer.parseInt("1800")) {
            this.getLog().warn((CharSequence)String.format("%s was set to be less then %2$s seconds, will use the default of %2$s seconds.", "waitMaxTime", "1800"));
            this.waitMaxTime = waitMaxTimeDefault;
        }
        if (!ChecksumRequest.isValidValue(this.checksums)) {
            throw new MojoExecutionException(String.format("%s must be one of the following values %s.", "checksums", ChecksumRequest.toNames()));
        }
        this.checksumRequest = ChecksumRequest.valueOf(this.checksums.toUpperCase());
        if (!WaitUntilRequest.isValidValue(this.waitUntil)) {
            throw new MojoExecutionException(String.format("%s must be one of the following values %s.", "waitUntil", WaitUntilRequest.toNames()));
        }
        this.waitUntilRequest = WaitUntilRequest.valueOf(this.waitUntil.toUpperCase());
        PublishingType publishingType = this.publishingType = this.autoPublish ? PublishingType.AUTOMATIC : PublishingType.USER_MANAGED;
        if (this.waitForPublishCompletion) {
            this.getLog().warn((CharSequence)String.format("waitForPublishCompletion is deprecated, using it will set %s to true and %s to %s.", "autoPublish", "waitUntil", WaitUntilRequest.PUBLISHED.name().toLowerCase()));
            this.publishingType = PublishingType.AUTOMATIC;
            this.waitUntilRequest = WaitUntilRequest.PUBLISHED;
        }
        if (this.waitUntilRequest == WaitUntilRequest.PUBLISHED && !this.autoPublish) {
            this.getLog().warn((CharSequence)String.format("Requested to wait for state: %s, but %s is set to %s (default). Waiting only until %s.", this.waitUntilRequest.name().toLowerCase(), "autoPublish", "false", WaitUntilRequest.VALIDATED.name().toLowerCase()));
            this.waitUntilRequest = WaitUntilRequest.VALIDATED;
        }
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        File deferredDirectory = this.getWorkDirectory(this.forcedDeferredDirectory, "central-deferred");
        File stagingDirectory = this.getWorkDirectory(this.forcedStagingDirectory, "central-staging");
        File outputDirectory = this.getWorkDirectory(this.forcedOutputDirectory, "central-publishing");
        List<ArtifactWithFile> artifactWithFiles = this.getArtifactWithFiles();
        if (this.getMavenSession().getCurrentProject().getArtifact().isSnapshot()) {
            this.processSnapshot(artifactWithFiles, deferredDirectory);
        } else {
            this.configurePublisherClient();
            this.processRelease(artifactWithFiles, stagingDirectory);
        }
        if (this.isThisLastProjectWithThisMojoInExecution()) {
            MojoExecutionException processSnapshotsFailure = null;
            try {
                this.postProcessSnapshot(deferredDirectory);
            }
            catch (MojoExecutionException e) {
                processSnapshotsFailure = e;
            }
            try {
                this.postProcessRelease(stagingDirectory, outputDirectory, this.deploymentName);
            }
            catch (Exception e) {
                if (null != processSnapshotsFailure) {
                    this.getLog().error((CharSequence)"Failed to deploy deferred artifacts", (Throwable)processSnapshotsFailure);
                }
                throw e;
            }
            if (null != processSnapshotsFailure) {
                throw processSnapshotsFailure;
            }
        }
    }

    private void postProcessSnapshot(File deferredDirectory) throws MojoExecutionException {
        try {
            if (Files.exists(new File(deferredDirectory, ".index").toPath(), new LinkOption[0])) {
                if (this.isSkipPublishing()) {
                    this.getLog().info((CharSequence)"Skipping Central SNAPSHOT Publishing at user's request.");
                    return;
                }
                this.artifactDeferrer.deployUp(this.getMavenSession(), deferredDirectory, null);
            } else {
                this.getLog().debug((CharSequence)"Skipping Central SNAPSHOT Publishing as no index with deferred artifacts were found.");
            }
        }
        catch (IOException | ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected void processSnapshot(List<ArtifactWithFile> artifactWithFiles, File deferredDirectory) throws MojoExecutionException {
        List<ArtifactWithFile> filteredArtifactWithFiles = artifactWithFiles.stream().filter(artifactWithFile -> !this.excludeArtifacts.contains(artifactWithFile.getArtifact().getArtifactId())).collect(Collectors.toList());
        try {
            this.artifactDeferrer.install(new DeferArtifactRequest(this.getMavenSession(), filteredArtifactWithFiles, deferredDirectory, this.centralSnapshotsUrl, this.publishingServerId));
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void processRelease(List<ArtifactWithFile> artifactWithFiles, File stagingDirectory) throws MojoExecutionException {
        List<ArtifactWithFile> filteredArtifactWithFiles = artifactWithFiles.stream().filter(artifactWithFile -> {
            if (this.excludeArtifacts.contains(artifactWithFile.getArtifact().getArtifactId())) {
                return false;
            }
            if (this.ignorePublishedComponents) {
                return !this.componentPublishedChecker.isComponentPublished(artifactWithFile.getArtifact().getGroupId(), artifactWithFile.getArtifact().getArtifactId(), artifactWithFile.getArtifact().getVersion());
            }
            return true;
        }).collect(Collectors.toList());
        try {
            this.artifactStager.stageArtifact(new StageArtifactRequest(filteredArtifactWithFiles, stagingDirectory));
            this.artifactBundler.preBundle(this.getMavenSession().getCurrentProject(), stagingDirectory.toPath(), this.checksumRequest);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void postProcessRelease(File stagingDirectory, File outputDirectory, String deploymentName) {
        if (!this.hasFiles(stagingDirectory)) {
            this.getLog().debug((CharSequence)"Skipping Central Release Publishing as no staged artifacts were found.");
            return;
        }
        Path bundleFile = this.artifactBundler.bundle(new BundleArtifactRequest(this.getMavenSession().getCurrentProject(), stagingDirectory, outputDirectory, this.outputFilename, this.checksumRequest));
        if (this.isSkipPublishing()) {
            this.getLog().info((CharSequence)"Skipping Central Release Publishing at user's request.");
            return;
        }
        UploadArtifactRequest uploadRequest = new UploadArtifactRequest(deploymentName, bundleFile, this.publishingType);
        String deploymentId = this.artifactUploader.upload(uploadRequest);
        if (this.waitUntilRequest == WaitUntilRequest.UPLOADED) {
            this.outputWhereToFinishPublishing(this.centralBaseUrl, this.waitUntilRequest, deploymentId);
            return;
        }
        WaitForDeploymentStateRequest waitForDeploymentStateRequest = new WaitForDeploymentStateRequest(this.centralBaseUrl, deploymentId, this.waitUntilRequest, this.waitMaxTime, this.waitPollingInterval);
        this.deploymentPublishedWatcher.waitForDeploymentState(waitForDeploymentStateRequest);
    }

    protected List<ArtifactWithFile> getArtifactWithFiles() throws MojoExecutionException {
        return Collections.unmodifiableList(this.getProjectUtils().getArtifacts(this.getMavenSession().getCurrentProject(), this.getArtifactFactory()));
    }

    protected synchronized File getWorkDirectory(File forcedWorkDirectory, String relativePath) {
        File workDirectory = forcedWorkDirectory;
        if (workDirectory == null) {
            workDirectory = this.getMojoUtils().getWorkDirectoryRoot(relativePath, this.getMavenSession(), this.getPluginGroupId(), this.getPluginArtifactId(), null);
        }
        if (this.getMojoUtils().isThisFirstProjectWithThisMojoInExecution(this.getMavenSession(), this.getMojoExecution(), this.getPluginGroupId(), this.getPluginArtifactId())) {
            this.ensureCleanDirectory(workDirectory);
        }
        return workDirectory;
    }

    private boolean isThisLastProjectWithThisMojoInExecution() {
        return this.getMojoUtils().isThisLastProjectWithThisMojoInExecution(this.getMavenSession(), this.getMojoExecution(), this.getPluginGroupId(), this.getPluginArtifactId(), this.isFailOnBuildFailure());
    }

    private void ensureCleanDirectory(File workingDirectory) {
        if (workingDirectory.exists() && workingDirectory.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)workingDirectory);
                this.getLog().debug((CharSequence)("Deleted existing working directory: " + workingDirectory));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to clean up working directory before plugin execution", e);
            }
        }
        try {
            Path workingDirectoryPath = workingDirectory.toPath();
            Files.createDirectories(workingDirectoryPath, new FileAttribute[0]);
            this.getLog().debug((CharSequence)("Created working directory: " + workingDirectoryPath));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create empty working directory before plugin execution", e);
        }
    }

    private void configurePublisherClient() {
        if (this.centralBaseUrl != null) {
            this.getLog().info((CharSequence)("Using Central baseUrl: " + this.centralBaseUrl));
            this.publisherClient.setCentralBaseUrl(this.centralBaseUrl);
        }
        this.getLog().info((CharSequence)("Using credentials from server id " + this.publishingServerId + " in settings.xml"));
        AuthData authData = this.getUserCredentials();
        this.getLog().info((CharSequence)("Using Usertoken auth, with namecode: " + authData.getUsername()));
        this.publisherClient.setAuthProvider(AuthProviderType.USERTOKEN, "org", authData.getUsername(), authData.getPassword());
    }

    private AuthData getUserCredentials() {
        try {
            Server server = this.getMavenSession().getSettings().getServer(this.publishingServerId);
            SettingsDecryptionResult settingsDecryptionResult = this.theCryptKeeper.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
            return new AuthData(settingsDecryptionResult.getServer().getUsername(), settingsDecryptionResult.getServer().getPassword());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get publisher server properties for server id: " + this.publishingServerId, e);
        }
    }

    private void outputWhereToFinishPublishing(String centralBaseURL, WaitUntilRequest waitUntilRequest, String deploymentId) {
        this.getLog().info((CharSequence)String.format("Deployment %s has been %s. To finish publishing visit %s/publishing/deployments", deploymentId, waitUntilRequest.name().toLowerCase(), centralBaseURL));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFiles(File directory) {
        try {
            Path path = directory.toPath();
            if (!Files.exists(path, new LinkOption[0])) return false;
            if (!Files.isDirectory(path, new LinkOption[0])) return false;
            try (Stream<Path> paths = Files.list(path);){
                boolean bl = paths.findFirst().isPresent();
                return bl;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

