/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.client.httpclient.auth;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.central.publisher.client.httpclient.auth.AuthProvider;

public abstract class AbstractAuthProvider
implements AuthProvider {
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private final String organizationId;
    private final String userId;
    private final String principal;
    private final String credential;

    protected AbstractAuthProvider(String organizationId, String userId, String principal, String credential) {
        this.headers.put("Authorization", this.buildAuthorizationHeaderValue(principal, credential));
        this.queryParams.put("orgId", organizationId);
        this.queryParams.put("userId", userId);
        this.organizationId = organizationId;
        this.userId = userId;
        this.principal = principal;
        this.credential = credential;
    }

    @Override
    public Map<String, String> getAuthHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    @Override
    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getPrincipal() {
        return this.principal;
    }

    @Override
    public String getCredential() {
        return this.credential;
    }

    private String buildAuthorizationHeaderValue(String principal, String credential) {
        String value = principal + ":" + credential;
        return this.getAuthScheme() + " " + Base64.getEncoder().encodeToString(value.getBytes());
    }

    protected abstract String getAuthScheme();
}

