/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.client;

import java.nio.file.Path;
import java.util.Map;
import org.sonatype.central.publisher.client.PublisherClient;
import org.sonatype.central.publisher.client.httpclient.ComponentPublishedEndpoint;
import org.sonatype.central.publisher.client.httpclient.StatusPublisherEndpoint;
import org.sonatype.central.publisher.client.httpclient.UploadPublisherEndpoint;
import org.sonatype.central.publisher.client.httpclient.auth.AuthProvider;
import org.sonatype.central.publisher.client.httpclient.auth.AuthProviderFactory;
import org.sonatype.central.publisher.client.httpclient.auth.AuthProviderType;
import org.sonatype.central.publisher.client.httpclient.utils.PublisherBundle;
import org.sonatype.central.publisher.client.model.DeploymentApiResponse;
import org.sonatype.central.publisher.client.model.PublishingType;

class PublisherClientImpl
implements PublisherClient {
    private String centralBaseUrl;
    private AuthProvider authProvider;
    private final UploadPublisherEndpoint uploadPublisherEndpoint;
    private final StatusPublisherEndpoint statusPublisherEndpoint;
    private final ComponentPublishedEndpoint componentPublishedEndpoint;
    private final AuthProviderFactory authProviderFactory;

    public PublisherClientImpl(UploadPublisherEndpoint uploadPublisherEndpoint, StatusPublisherEndpoint statusPublisherEndpoint, ComponentPublishedEndpoint componentPublishedEndpoint, AuthProviderFactory authProviderFactory) {
        this.uploadPublisherEndpoint = uploadPublisherEndpoint;
        this.statusPublisherEndpoint = statusPublisherEndpoint;
        this.componentPublishedEndpoint = componentPublishedEndpoint;
        this.authProviderFactory = authProviderFactory;
    }

    @Override
    public PublisherBundle compose(Path sourceDir, String bundleFileName) {
        return new PublisherBundle.BundleBuilder(sourceDir).bundleName(bundleFileName).addAllSourceFiles().build();
    }

    @Override
    public PublisherBundle compose(Path sourceDir, Path destDir, String bundleFileName) {
        return new PublisherBundle.BundleBuilder(sourceDir).destPath(destDir).bundleName(bundleFileName).addAllSourceFiles().build();
    }

    @Override
    public PublisherBundle.BundleBuilder getBuilder(Path sourceDir) {
        return new PublisherBundle.BundleBuilder(sourceDir);
    }

    @Override
    public String upload(String name, Path body, PublishingType publishingType) {
        Map<String, String> queryParams = this.authProvider().getQueryParams();
        queryParams.put("name", name);
        queryParams.put("publishingType", publishingType.name());
        return this.uploadPublisherEndpoint.call(this.centralBaseUrl(), this.authProvider(), queryParams, body);
    }

    @Override
    public DeploymentApiResponse status(String deploymentId) {
        Map<String, String> queryParams = this.authProvider().getQueryParams();
        queryParams.put("id", deploymentId);
        return this.statusPublisherEndpoint.call(this.centralBaseUrl(), this.authProvider(), queryParams);
    }

    @Override
    public boolean isPublished(String namespace, String name, String version) {
        Map<String, String> queryParams = this.authProvider().getQueryParams();
        queryParams.put("namespace", namespace);
        queryParams.put("name", name);
        queryParams.put("version", version);
        return this.componentPublishedEndpoint.call(this.centralBaseUrl(), this.authProvider(), queryParams);
    }

    @Override
    public AuthProvider setAuthProvider(AuthProviderType authProviderType, String organizationId, String userId, String principal, String credential) {
        this.authProvider = this.authProviderFactory.get(authProviderType, organizationId, userId, principal, credential);
        return this.authProvider;
    }

    private AuthProvider authProvider() {
        if (this.authProvider == null) {
            throw new IllegalStateException("An AuthProvider has not been set!");
        }
        return this.authProvider;
    }

    @Override
    public void setCentralBaseUrl(String centralBaseUrl) {
        this.centralBaseUrl = centralBaseUrl;
    }

    private String centralBaseUrl() {
        return this.centralBaseUrl != null ? this.centralBaseUrl : "https://central.sonatype.com";
    }
}

