/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.client.httpclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.hc.client5.http.HttpResponseException;
import org.sonatype.central.publisher.client.httpclient.PublisherHttpClient;
import org.sonatype.central.publisher.client.httpclient.RequestType;
import org.sonatype.central.publisher.client.httpclient.auth.AuthProvider;
import org.sonatype.central.publisher.client.httpclient.utils.HttpResponseUtil;
import org.sonatype.central.publisher.client.model.DeploymentApiResponse;

public class StatusPublisherEndpoint {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public DeploymentApiResponse call(String baseUrl, AuthProvider authProvider, Map<String, String> params) {
        try {
            String response = PublisherHttpClient.sendRequest(authProvider, baseUrl + "/api/v1/publisher/status", params, null, RequestType.POST);
            return (DeploymentApiResponse)this.objectMapper.readValue(response, DeploymentApiResponse.class);
        }
        catch (HttpResponseException e) {
            throw new RuntimeException("Cannot get deployment status. Response status code: " + e.getStatusCode() + " response message: " + HttpResponseUtil.toContentString(e));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

