/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.typed;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.api.typed.Input;
import com.sonar.sslr.api.typed.NodeBuilder;
import com.sonar.sslr.api.typed.Optional;
import com.sonar.sslr.impl.typed.GrammarBuilderInterceptor;
import com.sonar.sslr.impl.typed.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.vm.TokenExpression;
import org.sonar.sslr.internal.vm.TriviaExpression;

public class SyntaxTreeCreator<T> {
    private final Object treeFactory;
    private final GrammarBuilderInterceptor mapping;
    private final NodeBuilder nodeBuilder;
    private final Token.Builder tokenBuilder = Token.builder();
    private final List<Trivia> trivias = new ArrayList<Trivia>();
    private Input input;

    public SyntaxTreeCreator(Object treeFactory, GrammarBuilderInterceptor mapping, NodeBuilder nodeBuilder) {
        this.treeFactory = treeFactory;
        this.mapping = mapping;
        this.nodeBuilder = nodeBuilder;
    }

    public T create(ParseNode node, Input input) {
        this.input = input;
        this.trivias.clear();
        return (T)this.visit(node);
    }

    private Object visit(ParseNode node) {
        if (node.getMatcher() instanceof MutableParsingRule) {
            return this.visitNonTerminal(node);
        }
        return this.visitTerminal(node);
    }

    private Object visitNonTerminal(ParseNode node) {
        Optional<Object> result;
        MutableParsingRule rule = (MutableParsingRule)node.getMatcher();
        GrammarRuleKey ruleKey = rule.getRuleKey();
        Method method = this.mapping.actionForRuleKey(ruleKey);
        if (this.mapping.hasMethodForRuleKey(ruleKey)) {
            if (node.getChildren().size() != 1) {
                throw new IllegalStateException();
            }
            result = this.visit(node.getChildren().get(0));
        } else if (this.mapping.isOptionalRule(ruleKey)) {
            if (node.getChildren().size() > 1) {
                throw new IllegalStateException();
            }
            result = node.getChildren().isEmpty() ? Optional.absent() : Optional.of(this.visit(node.getChildren().get(0)));
        } else {
            ArrayList<Object> convertedChildren = new ArrayList<Object>();
            for (ParseNode child : node.getChildren()) {
                convertedChildren.add(this.visit(child));
            }
            result = this.mapping.isOneOrMoreRule(ruleKey) ? convertedChildren : (this.mapping.isZeroOrMoreRule(ruleKey) ? (convertedChildren.isEmpty() ? Optional.absent() : Optional.of(convertedChildren)) : (method == null ? this.nodeBuilder.createNonTerminal(ruleKey, rule, convertedChildren, node.getStartIndex(), node.getEndIndex()) : ReflectionUtils.invokeMethod(method, this.treeFactory, convertedChildren.toArray(new Object[0]))));
        }
        return result;
    }

    private Object visitTerminal(ParseNode node) {
        TokenType type = null;
        if (node.getMatcher() instanceof TriviaExpression) {
            TriviaExpression ruleMatcher = (TriviaExpression)node.getMatcher();
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.SKIPPED_TEXT) {
                return null;
            }
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.COMMENT) {
                this.addComment(node);
                return null;
            }
            throw new IllegalStateException("Unexpected trivia kind: " + (Object)((Object)ruleMatcher.getTriviaKind()));
        }
        if (node.getMatcher() instanceof TokenExpression) {
            TokenExpression ruleMatcher = (TokenExpression)node.getMatcher();
            type = ruleMatcher.getTokenType();
            if (GenericTokenType.COMMENT.equals(ruleMatcher.getTokenType())) {
                this.addComment(node);
                return null;
            }
        }
        Object result = this.nodeBuilder.createTerminal(this.input, node.getStartIndex(), node.getEndIndex(), this.trivias, type);
        this.trivias.clear();
        return result;
    }

    private void addComment(ParseNode node) {
        this.tokenBuilder.setGeneratedCode(false);
        int[] lineAndColumn = this.input.lineAndColumnAt(node.getStartIndex());
        this.tokenBuilder.setLine(lineAndColumn[0]);
        this.tokenBuilder.setColumn(lineAndColumn[1] - 1);
        this.tokenBuilder.setURI(this.input.uri());
        String value = this.input.substring(node.getStartIndex(), node.getEndIndex());
        this.tokenBuilder.setValueAndOriginalValue(value);
        this.tokenBuilder.setTrivia(Collections.emptyList());
        this.tokenBuilder.setType(GenericTokenType.COMMENT);
        this.trivias.add(Trivia.createComment(this.tokenBuilder.build()));
    }
}

