/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import java.util.ArrayList;
import java.util.Arrays;
import org.sonar.sslr.internal.matchers.InputBuffer;

public class ImmutableInputBuffer
implements InputBuffer {
    private final char[] buffer;
    private final int[] lines;

    public ImmutableInputBuffer(char[] buffer) {
        int i;
        this.buffer = buffer;
        ArrayList<Integer> newlines = new ArrayList<Integer>();
        newlines.add(0);
        for (i = 0; i < buffer.length; ++i) {
            if (!ImmutableInputBuffer.isEndOfLine(buffer, i)) continue;
            newlines.add(i + 1);
        }
        newlines.add(i);
        this.lines = new int[newlines.size()];
        for (i = 0; i < newlines.size(); ++i) {
            this.lines[i] = (Integer)newlines.get(i);
        }
    }

    @Override
    public int length() {
        return this.buffer.length;
    }

    @Override
    public char charAt(int i) {
        return this.buffer[i];
    }

    private static boolean isEndOfLine(char[] buffer, int i) {
        return buffer[i] == '\n' || buffer[i] == '\r' && (i + 1 < buffer.length && buffer[i + 1] != '\n' || i + 1 == buffer.length);
    }

    @Override
    public String extractLine(int lineNumber) {
        int start = this.lines[lineNumber - 1];
        int end = this.lines[lineNumber];
        return new String(this.buffer, start, end - start);
    }

    @Override
    public int getLineCount() {
        return this.lines.length - 1;
    }

    private int getLineNumber(int index) {
        int i = Arrays.binarySearch(this.lines, index);
        return Math.min(i >= 0 ? i + 1 : -(i + 1), this.getLineCount());
    }

    @Override
    public InputBuffer.Position getPosition(int index) {
        int line = this.getLineNumber(index);
        int column = index - this.lines[line - 1] + 1;
        return new InputBuffer.Position(line, column);
    }
}

