/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.typed;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.typed.GrammarBuilder;
import com.sonar.sslr.api.typed.NonterminalBuilder;
import com.sonar.sslr.api.typed.Optional;
import com.sonar.sslr.impl.typed.DelayedRuleInvocationExpression;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.internal.vm.FirstOfExpression;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.SequenceExpression;

public class GrammarBuilderInterceptor<T>
implements MethodInterceptor,
GrammarBuilder<T>,
NonterminalBuilder {
    private final LexerlessGrammarBuilder b;
    private final BiMap<Method, GrammarRuleKey> mapping = HashBiMap.create();
    private final BiMap<Method, GrammarRuleKey> actions = HashBiMap.create();
    private final Set<GrammarRuleKey> optionals = Sets.newHashSet();
    private final Set<GrammarRuleKey> oneOrMores = Sets.newHashSet();
    private final Set<GrammarRuleKey> zeroOrMores = Sets.newHashSet();
    private Method buildingMethod = null;
    private GrammarRuleKey ruleKey = null;
    private final Deque<ParsingExpression> expressionStack = new ArrayDeque<ParsingExpression>();

    public GrammarBuilderInterceptor(LexerlessGrammarBuilder b) {
        this.b = b;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            return proxy.invokeSuper(obj, args);
        }
        if (this.buildingMethod != null) {
            this.push(new DelayedRuleInvocationExpression(this.b, this, method));
            return null;
        }
        this.buildingMethod = method;
        return proxy.invokeSuper(obj, args);
    }

    @Override
    public <U> NonterminalBuilder<U> nonterminal() {
        return this.nonterminal(new DummyGrammarRuleKey(this.buildingMethod));
    }

    @Override
    public <U> NonterminalBuilder<U> nonterminal(GrammarRuleKey ruleKey) {
        this.ruleKey = ruleKey;
        this.mapping.put((Object)this.buildingMethod, (Object)this.ruleKey);
        return this;
    }

    public Object is(Object method) {
        Preconditions.checkState((this.expressionStack.size() == 1 ? 1 : 0) != 0, (Object)("Unexpected stack size: " + this.expressionStack.size()));
        ParsingExpression expression = this.pop();
        this.b.rule(this.ruleKey).is(expression);
        this.buildingMethod = null;
        this.ruleKey = null;
        return null;
    }

    @Override
    public <U> U firstOf(U ... methods) {
        FirstOfExpression expression = new FirstOfExpression(this.pop(methods.length));
        this.expressionStack.push(expression);
        return null;
    }

    @Override
    public <U> Optional<U> optional(U method) {
        ParsingExpression expression = this.pop();
        DummyGrammarRuleKey grammarRuleKey = new DummyGrammarRuleKey("optional", expression);
        this.optionals.add(grammarRuleKey);
        this.b.rule(grammarRuleKey).is(this.b.optional(expression));
        this.invokeRule(grammarRuleKey);
        return null;
    }

    @Override
    public <U> List<U> oneOrMore(U method) {
        ParsingExpression expression = this.pop();
        DummyGrammarRuleKey grammarRuleKey = new DummyGrammarRuleKey("oneOrMore", expression);
        this.oneOrMores.add(grammarRuleKey);
        this.b.rule(grammarRuleKey).is(this.b.oneOrMore(expression));
        this.invokeRule(grammarRuleKey);
        return null;
    }

    @Override
    public <U> Optional<List<U>> zeroOrMore(U method) {
        ParsingExpression expression = this.pop();
        DummyGrammarRuleKey grammarRuleKey = new DummyGrammarRuleKey("zeroOrMore", expression);
        this.zeroOrMores.add(grammarRuleKey);
        this.b.rule(grammarRuleKey).is(this.b.zeroOrMore(expression));
        this.invokeRule(grammarRuleKey);
        return null;
    }

    @Override
    public AstNode invokeRule(GrammarRuleKey grammarRuleKey) {
        this.pushDelayed(grammarRuleKey);
        return null;
    }

    @Override
    public T token(GrammarRuleKey grammarRuleKey) {
        this.pushDelayed(grammarRuleKey);
        return null;
    }

    private void pushDelayed(GrammarRuleKey grammarRuleKey) {
        this.push(new DelayedRuleInvocationExpression(this.b, grammarRuleKey));
    }

    public void replaceByRule(GrammarRuleKey grammarRuleKey, int stackElements) {
        ParsingExpression expression = stackElements == 1 ? this.pop() : new SequenceExpression(this.pop(stackElements));
        this.b.rule(grammarRuleKey).is(expression);
        this.invokeRule(grammarRuleKey);
    }

    private ParsingExpression[] pop(int n) {
        ParsingExpression[] result = new ParsingExpression[n];
        for (int i = n - 1; i >= 0; --i) {
            result[i] = this.pop();
        }
        return result;
    }

    private ParsingExpression pop() {
        return this.expressionStack.pop();
    }

    private void push(ParsingExpression expression) {
        this.expressionStack.push(expression);
    }

    public GrammarRuleKey ruleKeyForAction(Method method) {
        GrammarRuleKey grammarRuleKey = (GrammarRuleKey)this.actions.get((Object)method);
        if (grammarRuleKey == null) {
            method.setAccessible(true);
            grammarRuleKey = new DummyGrammarRuleKey(method);
            this.actions.put((Object)method, (Object)grammarRuleKey);
        }
        return grammarRuleKey;
    }

    @Nullable
    public Method actionForRuleKey(Object ruleKey) {
        return (Method)this.actions.inverse().get(ruleKey);
    }

    @Nullable
    public GrammarRuleKey ruleKeyForMethod(Method method) {
        return (GrammarRuleKey)this.mapping.get((Object)method);
    }

    public boolean hasMethodForRuleKey(Object ruleKey) {
        return this.mapping.containsValue(ruleKey);
    }

    public boolean isOptionalRule(Object ruleKey) {
        return this.optionals.contains(ruleKey);
    }

    public boolean isOneOrMoreRule(Object ruleKey) {
        return this.oneOrMores.contains(ruleKey);
    }

    public boolean isZeroOrMoreRule(Object ruleKey) {
        return this.zeroOrMores.contains(ruleKey);
    }

    private static class DummyGrammarRuleKey
    implements GrammarRuleKey {
        private final Method method;
        private final String operator;
        private final ParsingExpression expression;

        public DummyGrammarRuleKey(Method method) {
            this.method = method;
            this.operator = null;
            this.expression = null;
        }

        public DummyGrammarRuleKey(String operator, ParsingExpression expression) {
            this.method = null;
            this.operator = operator;
            this.expression = expression;
        }

        public String toString() {
            if (this.operator != null) {
                return this.operator + "(" + this.expression + ")";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("f.");
            sb.append(this.method.getName());
            sb.append('(');
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length - 1; ++i) {
                sb.append(parameterTypes[i].getSimpleName());
                sb.append(", ");
            }
            if (parameterTypes.length > 0) {
                sb.append(parameterTypes[parameterTypes.length - 1].getSimpleName());
            }
            sb.append(')');
            return sb.toString();
        }
    }
}

