/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api.typed;

import com.google.common.annotations.Beta;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.api.typed.Input;
import com.sonar.sslr.api.typed.NodeBuilder;
import java.util.List;
import org.sonar.sslr.grammar.GrammarRuleKey;

@Beta
public class AstNodeBuilder
implements NodeBuilder {
    private static final TokenType UNDEFINED_TOKEN_TYPE = new UndefinedTokenType();

    @Override
    public AstNode createNonTerminal(GrammarRuleKey ruleKey, Rule rule, List<Object> children, int startIndex, int endIndex) {
        Token token = null;
        for (Object child : children) {
            if (!(child instanceof AstNode) || !((AstNode)child).hasToken()) continue;
            token = ((AstNode)child).getToken();
            break;
        }
        AstNode astNode = new AstNode(rule, ruleKey.toString(), token);
        for (Object child : children) {
            astNode.addChild((AstNode)child);
        }
        astNode.setFromIndex(startIndex);
        astNode.setToIndex(endIndex);
        return astNode;
    }

    @Override
    public AstNode createTerminal(Input input, int startIndex, int endIndex, List<Trivia> trivias, TokenType type) {
        int[] lineAndColumn = input.lineAndColumnAt(startIndex);
        Token token = Token.builder().setType(type == null ? UNDEFINED_TOKEN_TYPE : type).setLine(lineAndColumn[0]).setColumn(lineAndColumn[1] - 1).setValueAndOriginalValue(input.substring(startIndex, endIndex)).setURI(input.uri()).setGeneratedCode(false).setTrivia(trivias).build();
        AstNode astNode = new AstNode(token);
        astNode.setFromIndex(startIndex);
        astNode.setToIndex(endIndex);
        return astNode;
    }

    private static final class UndefinedTokenType
    implements TokenType {
        private UndefinedTokenType() {
        }

        @Override
        public String getName() {
            return "TOKEN";
        }

        @Override
        public String getValue() {
            return this.getName();
        }

        @Override
        public boolean hasToBeSkippedFromAst(AstNode node) {
            return false;
        }

        public String toString() {
            return UndefinedTokenType.class.getSimpleName();
        }
    }
}

