/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api.typed;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.GrammarBuilder;
import com.sonar.sslr.api.typed.Input;
import com.sonar.sslr.api.typed.NodeBuilder;
import com.sonar.sslr.impl.typed.AstNodeSanitizer;
import com.sonar.sslr.impl.typed.GrammarBuilderInterceptor;
import com.sonar.sslr.impl.typed.ReflectionUtils;
import com.sonar.sslr.impl.typed.SyntaxTreeCreator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.parser.ParseError;
import org.sonar.sslr.parser.ParseErrorFormatter;
import org.sonar.sslr.parser.ParseRunner;
import org.sonar.sslr.parser.ParsingResult;

@Beta
public class ActionParser<N> {
    private final Charset charset;
    private final AstNodeSanitizer astNodeSanitizer = new AstNodeSanitizer();
    private final SyntaxTreeCreator<N> syntaxTreeCreator;
    private final GrammarRuleKey rootRule;
    private final ParseRunner parseRunner;

    public ActionParser(Charset charset, LexerlessGrammarBuilder b, Class grammarClass, Object treeFactory, NodeBuilder nodeBuilder, GrammarRuleKey rootRule) {
        this.charset = charset;
        GrammarBuilderInterceptor grammarBuilderInterceptor = new GrammarBuilderInterceptor(b);
        Enhancer grammarEnhancer = new Enhancer();
        grammarEnhancer.setSuperclass(grammarClass);
        grammarEnhancer.setCallback(grammarBuilderInterceptor);
        ActionMethodInterceptor actionMethodInterceptor = new ActionMethodInterceptor(grammarBuilderInterceptor);
        Enhancer actionEnhancer = new Enhancer();
        actionEnhancer.setSuperclass(treeFactory.getClass());
        actionEnhancer.setCallback((Callback)actionMethodInterceptor);
        Object grammar = grammarEnhancer.create(new Class[]{GrammarBuilder.class, treeFactory.getClass()}, new Object[]{grammarBuilderInterceptor, actionEnhancer.create()});
        for (Method method : grammarClass.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            ReflectionUtils.invokeMethod(method, grammar, new Object[0]);
        }
        this.syntaxTreeCreator = new SyntaxTreeCreator(treeFactory, grammarBuilderInterceptor, nodeBuilder);
        b.setRootRule(rootRule);
        this.rootRule = rootRule;
        this.parseRunner = new ParseRunner(b.build().getRootRule());
    }

    public N parse(File file) {
        try {
            return this.parse(new Input(Files.toString((File)file, (Charset)this.charset).toCharArray(), file.toURI()));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public N parse(String source) {
        return this.parse(new Input(source.toCharArray()));
    }

    private N parse(Input input) {
        ParsingResult result = this.parseRunner.parse(input.input());
        if (!result.isMatched()) {
            ParseError parseError = result.getParseError();
            InputBuffer inputBuffer = parseError.getInputBuffer();
            int line = inputBuffer.getPosition(parseError.getErrorIndex()).getLine();
            String message = new ParseErrorFormatter().format(parseError);
            throw new RecognitionException(line, message);
        }
        N node = this.syntaxTreeCreator.create(result.getParseTreeRoot(), input);
        if (node instanceof AstNode) {
            this.astNodeSanitizer.sanitize((AstNode)node);
        }
        return node;
    }

    public GrammarRuleKey rootRule() {
        return this.rootRule;
    }

    private static class ActionMethodInterceptor
    implements MethodInterceptor {
        private final GrammarBuilderInterceptor grammarBuilderInterceptor;

        public ActionMethodInterceptor(GrammarBuilderInterceptor grammarBuilderInterceptor) {
            this.grammarBuilderInterceptor = grammarBuilderInterceptor;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getDeclaringClass().equals(Object.class)) {
                return proxy.invokeSuper(obj, args);
            }
            GrammarRuleKey ruleKey = this.grammarBuilderInterceptor.ruleKeyForAction(method);
            this.grammarBuilderInterceptor.replaceByRule(ruleKey, args.length);
            return null;
        }
    }
}

