/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1172")
public class UnusedMethodParameterCheck
extends IssuableSubscriptionVisitor {
    private static final String AUTHORIZED_ANNOTATION = "javax.enterprise.event.Observes";
    private static final String SUPPRESS_WARNINGS_ANNOTATION = "java.lang.SuppressWarnings";
    private static final Collection<String> EXCLUDED_WARNINGS_SUPPRESSIONS = ImmutableList.of((Object)"\"rawtypes\"", (Object)"\"unchecked\"");
    private static final MethodMatcherCollection SERIALIZABLE_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().name("writeObject").addParameter("java.io.ObjectOutputStream"), MethodMatcher.create().name("readObject").addParameter("java.io.ObjectInputStream")});
    private static final String STRUTS_ACTION_SUPERCLASS = "org.apache.struts.action.Action";
    private static final Collection<String> EXCLUDED_STRUTS_ACTION_PARAMETER_TYPES = ImmutableList.of((Object)"org.apache.struts.action.ActionMapping", (Object)"org.apache.struts.action.ActionForm", (Object)"javax.servlet.http.HttpServletRequest", (Object)"javax.servlet.http.HttpServletResponse");
    private static final Pattern PARAMETER_JAVADOC_PATTERN = Pattern.compile(".*@param\\s++(?<name>\\S*)(\\s++)?(?<descr>.+)?");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.block() == null || UnusedMethodParameterCheck.isExcluded(methodTree)) {
            return;
        }
        Set<String> documentedParameters = UnusedMethodParameterCheck.documentedParameters(methodTree);
        boolean overridableMethod = UnusedMethodParameterCheck.overridableMethod(methodTree.symbol());
        List<Object> unused = Lists.newArrayList();
        for (VariableTree var : methodTree.parameters()) {
            Symbol symbol = var.symbol();
            if (!symbol.usages().isEmpty() || symbol.metadata().isAnnotatedWith(AUTHORIZED_ANNOTATION) || UnusedMethodParameterCheck.isStrutsActionParameter(var) || overridableMethod && documentedParameters.contains(symbol.name())) continue;
            unused.add(var.simpleName());
        }
        Set<String> unresolvedIdentifierNames = UnusedMethodParameterCheck.unresolvedIdentifierNames((Tree)methodTree.block());
        if (!(unused = unused.stream().filter(id -> !unresolvedIdentifierNames.contains(id.name())).collect(Collectors.toList())).isEmpty()) {
            this.reportUnusedParameters(unused);
        }
    }

    private void reportUnusedParameters(List<IdentifierTree> unused) {
        ArrayList<JavaFileScannerContext.Location> locations = new ArrayList<JavaFileScannerContext.Location>();
        for (IdentifierTree identifier : unused) {
            locations.add(new JavaFileScannerContext.Location("Remove this unused method parameter " + identifier.name() + "\".", (Tree)identifier));
        }
        IdentifierTree firstUnused = unused.get(0);
        String msg = unused.size() > 1 ? "Remove these unused method parameters." : "Remove this unused method parameter \"" + firstUnused.name() + "\".";
        this.reportIssue((Tree)firstUnused, msg, locations, null);
    }

    private static boolean overridableMethod(Symbol.MethodSymbol symbol) {
        return !symbol.isPrivate() && !symbol.isStatic() && !symbol.isFinal() && !symbol.owner().isFinal();
    }

    private static Set<String> documentedParameters(MethodTree methodTree) {
        return methodTree.firstToken().trivias().stream().map(SyntaxTrivia::comment).map(c -> c.split("\\r?\\n")).flatMap(Arrays::stream).map(PARAMETER_JAVADOC_PATTERN::matcher).filter(Matcher::matches).map(matcher -> matcher.group("name")).collect(Collectors.toSet());
    }

    private static boolean isExcluded(MethodTree tree) {
        return ((MethodTreeImpl)tree).isMainMethod() || UnusedMethodParameterCheck.isAnnotated(tree) || UnusedMethodParameterCheck.isOverriding(tree) || UnusedMethodParameterCheck.isSerializableMethod(tree) || UnusedMethodParameterCheck.isDesignedForExtension(tree);
    }

    private static boolean isAnnotated(MethodTree tree) {
        return tree.modifiers().annotations().stream().anyMatch(annotation -> !UnusedMethodParameterCheck.isExcludedLiteral((Tree)annotation));
    }

    private static boolean isExcludedLiteral(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            return annotationTree.annotationType().symbolType().is(SUPPRESS_WARNINGS_ANNOTATION) && annotationTree.arguments().stream().allMatch(UnusedMethodParameterCheck::isExcludedLiteral);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return EXCLUDED_WARNINGS_SUPPRESSIONS.contains(((LiteralTree)tree).value());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            return ((NewArrayTree)tree).initializers().stream().allMatch(UnusedMethodParameterCheck::isExcludedLiteral);
        }
        return false;
    }

    private static boolean isDesignedForExtension(MethodTree tree) {
        if (tree.symbol().enclosingClass().isFinal()) {
            return false;
        }
        ModifiersTree modifiers = tree.modifiers();
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.DEFAULT) || !ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.PRIVATE) && UnusedMethodParameterCheck.isEmptyOrThrowStatement(tree.block());
    }

    private static boolean isStrutsActionParameter(VariableTree variableTree) {
        Type superClass = variableTree.symbol().enclosingClass().superClass();
        return superClass != null && superClass.isSubtypeOf(STRUTS_ACTION_SUPERCLASS) && EXCLUDED_STRUTS_ACTION_PARAMETER_TYPES.contains(variableTree.symbol().type().fullyQualifiedName());
    }

    private static boolean isEmptyOrThrowStatement(BlockTree block) {
        return block.body().isEmpty() || block.body().size() == 1 && ((StatementTree)block.body().get(0)).is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT});
    }

    private static boolean isSerializableMethod(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.PRIVATE) && SERIALIZABLE_METHODS.anyMatch(methodTree);
    }

    private static boolean isOverriding(MethodTree tree) {
        return !BooleanUtils.isFalse((Boolean)((MethodTreeImpl)tree).isOverriding());
    }

    private static Set<String> unresolvedIdentifierNames(Tree tree) {
        UnresolvedIdentifierVisitor visitor = new UnresolvedIdentifierVisitor();
        tree.accept((TreeVisitor)visitor);
        return visitor.unresolvedIdentifierNames;
    }

    private static class UnresolvedIdentifierVisitor
    extends BaseTreeVisitor {
        private Set<String> unresolvedIdentifierNames = new HashSet<String>();

        private UnresolvedIdentifierVisitor() {
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            this.scan((Tree)tree.expression());
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            ExpressionTree methodSelect = tree.methodSelect();
            if (!methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.scan((Tree)methodSelect);
            }
            this.scan((ListTree)tree.typeArguments());
            this.scan((ListTree)tree.arguments());
        }

        public void visitIdentifier(IdentifierTree tree) {
            if (tree.symbol().isUnknown()) {
                this.unresolvedIdentifierNames.add(tree.name());
            }
            super.visitIdentifier(tree);
        }
    }
}

