/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2757")
public class WrongAssignmentOperatorCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> SUSPICIOUS_TOKEN_VALUES = ImmutableSet.of((Object)"!", (Object)"+", (Object)"-");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        AssignmentExpressionTree aeTree = (AssignmentExpressionTree)tree;
        SyntaxToken operatorToken = aeTree.operatorToken();
        SyntaxToken expressionFirstToken = aeTree.expression().firstToken();
        SyntaxToken variableLastToken = aeTree.variable().lastToken();
        if (WrongAssignmentOperatorCheck.isSuspiciousToken(expressionFirstToken) && WrongAssignmentOperatorCheck.noSpacingBetween(operatorToken, expressionFirstToken) && !WrongAssignmentOperatorCheck.noSpacingBetween(variableLastToken, operatorToken)) {
            this.reportIssue((Tree)operatorToken, (Tree)expressionFirstToken, "Was \"" + expressionFirstToken.text() + "=\" meant instead?");
        }
    }

    private static boolean noSpacingBetween(SyntaxToken firstToken, SyntaxToken secondToken) {
        return firstToken.column() + firstToken.text().length() == secondToken.column();
    }

    private static boolean isSuspiciousToken(SyntaxToken firstToken) {
        return SUSPICIOUS_TOKEN_VALUES.contains(firstToken.text());
    }
}

