/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="UselessImportCheck")
@RspecKey(value="S1128")
public class UselessImportCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Map<String, ImportTree> lineByImportReference = new HashMap<String, ImportTree>();
    private final Set<String> pendingImports = Sets.newHashSet();
    private final Set<String> pendingReferences = Sets.newHashSet();
    private String currentPackage;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        CompilationUnitTree cut = context.getTree();
        if (cut.moduleDeclaration() != null) {
            return;
        }
        ExpressionTree packageName = UselessImportCheck.getPackageName(cut);
        this.pendingReferences.clear();
        this.lineByImportReference.clear();
        this.pendingImports.clear();
        this.currentPackage = ExpressionsHelper.concatenate(packageName);
        for (ImportClauseTree importClauseTree : cut.imports()) {
            ImportTree importTree = null;
            if (importClauseTree.is(new Tree.Kind[]{Tree.Kind.IMPORT})) {
                importTree = (ImportTree)importClauseTree;
            }
            if (importTree == null || importTree.isStatic()) continue;
            this.reportIssue(importTree);
        }
        this.scan((Tree)cut);
        new CommentVisitor().checkImportsFromComments(cut, this.pendingImports);
        this.leaveFile();
    }

    private void reportIssue(ImportTree importTree) {
        String importName = ExpressionsHelper.concatenate((ExpressionTree)importTree.qualifiedIdentifier());
        if ("java.lang.*".equals(importName)) {
            this.context.reportIssue((JavaCheck)this, (Tree)importTree, "Remove this unnecessary import: java.lang classes are always implicitly imported.");
        } else if (this.isImportFromSamePackage(importName)) {
            this.context.reportIssue((JavaCheck)this, (Tree)importTree, "Remove this unnecessary import: same package classes are always implicitly imported.");
        } else if (!UselessImportCheck.isImportOnDemand(importName)) {
            if (UselessImportCheck.isJavaLangImport(importName)) {
                this.context.reportIssue((JavaCheck)this, (Tree)importTree, "Remove this unnecessary import: java.lang classes are always implicitly imported.");
            } else if (this.isDuplicatedImport(importName)) {
                this.context.reportIssue((JavaCheck)this, (Tree)importTree, "Remove this duplicated import.");
            } else {
                this.lineByImportReference.put(importName, importTree);
                this.pendingImports.add(importName);
            }
        }
    }

    private static ExpressionTree getPackageName(CompilationUnitTree cut) {
        return cut.packageDeclaration() != null ? cut.packageDeclaration().packageName() : null;
    }

    private static boolean isImportOnDemand(String name) {
        return name.endsWith("*");
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (tree.packageDeclaration() != null) {
            this.scan(tree.packageDeclaration().annotations());
        }
        this.scan(tree.types());
    }

    public void visitIdentifier(IdentifierTree tree) {
        this.scan(tree.annotations());
        this.pendingReferences.add(tree.name());
    }

    public void visitArrayType(ArrayTypeTree tree) {
        this.scan(tree.annotations());
        super.visitArrayType(tree);
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.scan(tree.annotations());
        this.scan(tree.identifier().annotations());
        this.pendingReferences.add(ExpressionsHelper.concatenate((ExpressionTree)tree));
        if (!tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.scan((Tree)tree.expression());
        }
    }

    private boolean isImportFromSamePackage(String reference) {
        String importName = reference;
        if (UselessImportCheck.isImportOnDemand(reference)) {
            importName = reference.substring(0, reference.length() - 2);
        }
        return !this.currentPackage.isEmpty() && importName.startsWith(this.currentPackage) && (importName.length() == this.currentPackage.length() || reference.substring(reference.indexOf(this.currentPackage)).charAt(0) == '.');
    }

    private boolean isDuplicatedImport(String reference) {
        return this.pendingImports.contains(reference);
    }

    private static boolean isJavaLangImport(String reference) {
        return reference.startsWith("java.lang.") && reference.indexOf(46, "java.lang.".length()) == -1;
    }

    public void leaveFile() {
        for (String reference : this.pendingReferences) {
            this.updatePendingImports(reference);
        }
        for (String pendingImport : this.pendingImports) {
            this.context.reportIssue((JavaCheck)this, (Tree)this.lineByImportReference.get(pendingImport), "Remove this unused import '" + pendingImport + "'.");
        }
    }

    private void updatePendingImports(String reference) {
        String firstClassReference = reference;
        if (UselessImportCheck.isFullyQualified(firstClassReference)) {
            firstClassReference = UselessImportCheck.extractFirstClassName(firstClassReference);
        }
        Iterator<String> it = this.pendingImports.iterator();
        while (it.hasNext()) {
            String pendingImport = it.next();
            if (!pendingImport.endsWith("." + firstClassReference)) continue;
            it.remove();
        }
    }

    private static boolean isFullyQualified(String reference) {
        return reference.indexOf(46) != -1;
    }

    private static String extractFirstClassName(String reference) {
        int firstIndexOfDot = reference.indexOf(46);
        return firstIndexOfDot == -1 ? reference : reference.substring(0, firstIndexOfDot);
    }

    private static class CommentVisitor
    extends IssuableSubscriptionVisitor {
        private Set<String> pendingImports;

        private CommentVisitor() {
        }

        public List<Tree.Kind> nodesToVisit() {
            return ImmutableList.of((Object)Tree.Kind.TRIVIA);
        }

        public void checkImportsFromComments(CompilationUnitTree cut, Set<String> pendingImports) {
            this.pendingImports = pendingImports;
            this.scanTree((Tree)cut);
        }

        public void visitTrivia(SyntaxTrivia syntaxTrivia) {
            this.updatePendingImportsForComments(syntaxTrivia.comment());
        }

        private void updatePendingImportsForComments(String comment) {
            Iterator<String> it = this.pendingImports.iterator();
            while (it.hasNext()) {
                String pendingImport = it.next();
                if (!comment.contains(CommentVisitor.extractLastClassName(pendingImport))) continue;
                it.remove();
            }
        }

        private static String extractLastClassName(String reference) {
            int lastIndexOfDot = reference.lastIndexOf(46);
            return lastIndexOfDot == -1 ? reference : reference.substring(lastIndexOfDot + 1);
        }
    }
}

