/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1160")
public class ThrowsSeveralCheckedExceptionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        List<String> thrownCheckedExceptions;
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && ThrowsSeveralCheckedExceptionCheck.isPublic(methodTree) && !((MethodTreeImpl)methodTree).isMainMethod() && (thrownCheckedExceptions = ThrowsSeveralCheckedExceptionCheck.getThrownCheckedExceptions(methodTree)).size() > 1 && ThrowsSeveralCheckedExceptionCheck.isNotOverriden(methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Refactor this method to throw at most one checked exception instead of: " + Joiner.on((String)", ").join(thrownCheckedExceptions));
        }
    }

    private static boolean isNotOverriden(MethodTree methodTree) {
        return BooleanUtils.isFalse((Boolean)((MethodTreeImpl)methodTree).isOverriding());
    }

    private static boolean isPublic(MethodTree methodTree) {
        return methodTree.symbol().isPublic();
    }

    private static List<String> getThrownCheckedExceptions(MethodTree methodTree) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type thrownClass : methodTree.symbol().thrownTypes()) {
            if (thrownClass.isUnknown() || ThrowsSeveralCheckedExceptionCheck.isSubClassOfRuntimeException(thrownClass)) continue;
            builder.add((Object)thrownClass.fullyQualifiedName());
        }
        return builder.build();
    }

    private static boolean isSubClassOfRuntimeException(Type thrownClass) {
        Symbol.TypeSymbol typeSymbol = thrownClass.symbol();
        while (typeSymbol != null) {
            if (ThrowsSeveralCheckedExceptionCheck.isRuntimeException(typeSymbol.type())) {
                return true;
            }
            Type superType = typeSymbol.superClass();
            if (superType == null) {
                typeSymbol = null;
                continue;
            }
            typeSymbol = superType.symbol();
        }
        return false;
    }

    private static boolean isRuntimeException(Type thrownClass) {
        return thrownClass.is("java.lang.RuntimeException");
    }
}

