/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1161")
public class OverrideAnnotationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic() || OverrideAnnotationCheck.isExcludedByVersion(this.context.getJavaVersion())) {
            return;
        }
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        JavaSymbol.MethodJavaSymbol overriddenSymbol = ((JavaSymbol.MethodJavaSymbol)methodTree.symbol()).overriddenSymbol();
        if (overriddenSymbol == null || overriddenSymbol.isUnknown()) {
            return;
        }
        if (!(overriddenSymbol.isAbstract() || overriddenSymbol.owner().type().is("java.lang.Object") || methodTree.isAnnotatedOverride())) {
            this.reportIssue((Tree)methodTree.simpleName(), "Add the \"@Override\" annotation above this method signature");
        }
    }

    private static boolean isExcludedByVersion(JavaVersion javaVersion) {
        if (javaVersion.isNotSet()) {
            return false;
        }
        return javaVersion.asInt() <= 4;
    }
}

