/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2786")
public class NestedEnumStaticCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        ModifierKeywordTree staticKeyword = ModifiersUtils.getModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.STATIC);
        if (staticKeyword != null) {
            List<JavaFileScannerContext.Location> secondary = Collections.singletonList(new JavaFileScannerContext.Location("", (Tree)classTree.declarationKeyword()));
            this.reportIssue((Tree)staticKeyword, "Remove this redundant \"static\" qualifier.", secondary, null);
        }
    }
}

