/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="IndentationCheck")
@RspecKey(value="S1120")
public class IndentationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_INDENTATION_LEVEL = 2;
    @RuleProperty(key="indentationLevel", description="Number of white-spaces of an indent.", defaultValue="2")
    public int indentationLevel = 2;
    private int expectedLevel;
    private boolean isBlockAlreadyReported;
    private int excludeIssueAtLine;
    private JavaFileScannerContext context;
    private List<String> fileLines;

    public void scanFile(JavaFileScannerContext context) {
        this.expectedLevel = 0;
        this.isBlockAlreadyReported = false;
        this.excludeIssueAtLine = 0;
        this.context = context;
        this.fileLines = context.getFileLines();
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        boolean isAnonymous;
        boolean bl = isAnonymous = tree.simpleName() == null;
        if (!isAnonymous) {
            this.checkIndentation(Collections.singletonList(tree));
        }
        int previousLevel = this.expectedLevel;
        if (isAnonymous) {
            this.excludeIssueAtLine = tree.openBraceToken().line();
            this.expectedLevel = tree.closeBraceToken().column();
        }
        this.newBlock();
        this.checkIndentation(tree.members());
        super.visitClass(tree);
        this.leaveNode((Tree)tree);
        this.expectedLevel = previousLevel;
    }

    public void visitBlock(BlockTree tree) {
        this.newBlock();
        this.adjustBlockForExceptionalParents(tree.parent());
        this.checkIndentation(tree.body());
        super.visitBlock(tree);
        this.restoreBlockForExceptionalParents(tree.parent());
        this.leaveNode((Tree)tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.newBlock();
        this.scan((Tree)tree.expression());
        for (CaseGroupTree caseGroupTree : tree.cases()) {
            this.newBlock();
            this.checkCaseGroup(caseGroupTree);
            this.scan((Tree)caseGroupTree);
            this.leaveNode((Tree)caseGroupTree);
        }
        this.leaveNode((Tree)tree);
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        Tree body = lambdaExpressionTree.body();
        if (body.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)body;
            this.excludeIssueAtLine = block.openBraceToken().line();
            int previousLevel = this.expectedLevel;
            this.expectedLevel = block.closeBraceToken().column();
            this.scan((Tree)block);
            this.expectedLevel = previousLevel;
        } else {
            this.scan(body);
        }
    }

    private void newBlock() {
        this.expectedLevel += this.indentationLevel;
        this.isBlockAlreadyReported = false;
    }

    private void leaveNode(Tree tree) {
        this.expectedLevel -= this.indentationLevel;
        this.isBlockAlreadyReported = false;
        this.excludeIssueAtLine = tree.lastToken().line();
    }

    private void checkCaseGroup(CaseGroupTree tree) {
        List body;
        List labels = tree.labels();
        if (labels.size() >= 2) {
            CaseLabelTree previousCaseLabelTree = (CaseLabelTree)labels.get(labels.size() - 2);
            this.excludeIssueAtLine = previousCaseLabelTree.lastToken().line();
        }
        List newBody = body = tree.body();
        int bodySize = body.size();
        if (bodySize > 0 && ((StatementTree)body.get(0)).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.expectedLevel -= this.indentationLevel;
            this.checkIndentation((Tree)body.get(0), ((CaseLabelTree)Iterables.getLast((Iterable)labels)).colonToken().column() + 2);
            newBody = body.subList(1, bodySize);
        }
        this.checkIndentation(newBody);
        if (bodySize > 0 && ((StatementTree)body.get(0)).is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.expectedLevel += this.indentationLevel;
        }
    }

    private void adjustBlockForExceptionalParents(Tree parent) {
        if (parent.is(new Tree.Kind[]{Tree.Kind.CASE_GROUP})) {
            this.expectedLevel -= this.indentationLevel;
        }
    }

    private void restoreBlockForExceptionalParents(Tree parent) {
        if (parent.is(new Tree.Kind[]{Tree.Kind.CASE_GROUP})) {
            this.expectedLevel += this.indentationLevel;
        }
    }

    private void checkIndentation(List<? extends Tree> trees) {
        for (Tree tree : trees) {
            this.checkIndentation(tree, this.expectedLevel);
        }
    }

    private void checkIndentation(Tree tree, int expectedLevel) {
        SyntaxToken firstSyntaxToken = tree.firstToken();
        String line = this.fileLines.get(firstSyntaxToken.line() - 1);
        int level = firstSyntaxToken.column();
        for (int i = 0; i < firstSyntaxToken.column(); ++i) {
            if (line.charAt(i) != '\t') continue;
            level += this.indentationLevel - 1;
        }
        if (level != expectedLevel && !this.isExcluded(tree, firstSyntaxToken.line())) {
            this.context.addIssue(((JavaTree)tree).getLine(), (JavaCheck)this, "Make this line start at column " + (expectedLevel + 1) + ".");
            this.isBlockAlreadyReported = true;
        }
        this.excludeIssueAtLine = tree.lastToken().line();
    }

    private boolean isExcluded(Tree node, int nodeLine) {
        return this.excludeIssueAtLine == nodeLine || this.isBlockAlreadyReported || node.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT});
    }
}

