/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Splitter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1313")
public class HardcodedIpCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Matcher IP = Pattern.compile("([^\\d.]*\\/)?(?<ip>(?:\\d{1,3}\\.){3}\\d{1,3}(?!\\d|\\.))(\\/.*)?").matcher("");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitLiteral(LiteralTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String value = LiteralUtils.trimQuotes((String)tree.value());
            IP.reset(value);
            if (IP.matches()) {
                String ip = IP.group("ip");
                if (HardcodedIpCheck.areAllBelow256(Splitter.on((char)'.').split((CharSequence)ip))) {
                    this.context.reportIssue((JavaCheck)this, (Tree)tree, "Make this IP \"" + ip + "\" address configurable.");
                }
            }
        }
    }

    private static boolean areAllBelow256(Iterable<String> numbersAsStrings) {
        for (String numberAsString : numbersAsStrings) {
            if (Integer.valueOf(numberAsString) <= 255) continue;
            return false;
        }
        return true;
    }
}

