/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2068")
public class HardCodedCredentialsCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_CREDENTIAL_WORDS = "password,passwd,pwd";
    private static final MethodMatcher PASSWORD_AUTHENTICATION_CONSTRUCTOR = MethodMatcher.create().typeDefinition("java.net.PasswordAuthentication").name("<init>").addParameter("java.lang.String").addParameter("char[]");
    private static final MethodMatcher STRING_TO_CHAR_ARRAY = MethodMatcher.create().typeDefinition("java.lang.String").name("toCharArray").withoutParameter();
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd")
    public String credentialWords = "password,passwd,pwd";
    private List<Pattern> variablePatterns = null;
    private List<Pattern> literalPatterns = null;

    private Stream<Pattern> variablePatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            this.literalPatterns = this.toPatterns("=\\S.");
        }
        return this.literalPatterns.stream();
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.credentialWords.split(",")).map(String::trim).map(word -> Pattern.compile("(" + word + ")" + suffix, 2)).collect(Collectors.toList());
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.STRING_LITERAL, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.handleStringLiteral((LiteralTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.handleVariable((VariableTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.handleAssignement((AssignmentExpressionTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            this.handleConstructor((NewClassTree)tree);
        } else {
            this.handleMethodInvocation((MethodInvocationTree)tree);
        }
    }

    private Optional<String> isSettingPassword(MethodInvocationTree tree) {
        Arguments arguments = tree.arguments();
        if (arguments.size() == 2 && HardCodedCredentialsCheck.argumentsAreLiterals((List<ExpressionTree>)arguments)) {
            return this.isPassword((LiteralTree)arguments.get(0));
        }
        return Optional.empty();
    }

    private Optional<String> isPassword(LiteralTree argument) {
        if (!argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return Optional.empty();
        }
        String cleanedLiteral = LiteralUtils.trimQuotes((String)argument.value());
        return this.variablePatterns().map(pattern -> pattern.matcher(cleanedLiteral)).filter(Matcher::matches).map(matcher -> matcher.group(1)).findAny();
    }

    private Optional<String> isPasswordVariableName(IdentifierTree identifierTree) {
        String identifierName = identifierTree.name();
        return this.variablePatterns().map(pattern -> pattern.matcher(identifierName)).filter(Matcher::find).map(matcher -> matcher.group(1)).findAny();
    }

    private Optional<String> isPasswordVariable(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return this.isPasswordVariableName(((MemberSelectExpressionTree)variable).identifier());
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return this.isPasswordVariableName((IdentifierTree)variable);
        }
        return Optional.empty();
    }

    private static boolean isCallOnStringLiteral(ExpressionTree expr) {
        return expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && ((MemberSelectExpressionTree)expr).expression().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    private void handleStringLiteral(LiteralTree tree) {
        String cleanedLiteral = LiteralUtils.trimQuotes((String)tree.value());
        this.literalPatterns().map(pattern -> pattern.matcher(cleanedLiteral)).filter(Matcher::find).map(matcher -> matcher.group(1)).findAny().ifPresent(credential -> this.report((Tree)tree, (String)credential));
    }

    private void handleVariable(VariableTree tree) {
        IdentifierTree variable = tree.simpleName();
        if (HardCodedCredentialsCheck.isStringLiteral(tree.initializer())) {
            this.isPasswordVariableName(variable).ifPresent(passwordVariableName -> this.report((Tree)variable, (String)passwordVariableName));
        }
    }

    private void handleAssignement(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (HardCodedCredentialsCheck.isStringLiteral(tree.expression())) {
            this.isPasswordVariable(variable).ifPresent(passwordVariableName -> this.report((Tree)variable, (String)passwordVariableName));
        }
    }

    private static boolean argumentsAreLiterals(List<ExpressionTree> arguments) {
        return arguments.stream().allMatch(arg -> arg.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.NULL_LITERAL}));
    }

    private static boolean isStringLiteral(@Nullable ExpressionTree initializer) {
        return initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    private void handleConstructor(NewClassTree tree) {
        MethodInvocationTree mit;
        if (!PASSWORD_AUTHENTICATION_CONSTRUCTOR.matches(tree)) {
            return;
        }
        ExpressionTree secondArg = (ExpressionTree)tree.arguments().get(1);
        if (secondArg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && HardCodedCredentialsCheck.isCallOnStringLiteral((mit = (MethodInvocationTree)secondArg).methodSelect()) && STRING_TO_CHAR_ARRAY.matches(mit)) {
            this.reportIssue((Tree)tree, "Remove this hard-coded password.");
        }
    }

    private void handleMethodInvocation(MethodInvocationTree tree) {
        this.isSettingPassword(tree).ifPresent(settingPassword -> this.report((Tree)tree.methodSelect(), (String)settingPassword));
    }

    private void report(Tree tree, String match) {
        this.reportIssue(tree, "'" + match + "' detected in this expression, review this potentially hardcoded credential.");
    }
}

