/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1451")
public class FileHeaderCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_HEADER_FORMAT = "";
    private static final String MESSAGE = "Add or update the header of this file.";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private String[] expectedLines;
    private Pattern searchPattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (this.isRegularExpression) {
            if (this.searchPattern == null) {
                try {
                    this.searchPattern = Pattern.compile(this.getHeaderFormat(), 32);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("[" + ((Object)((Object)this)).getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
                }
            }
        } else {
            this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
        }
        this.visitFile();
    }

    private String getHeaderFormat() {
        String format = this.headerFormat;
        if (format.charAt(0) != '^') {
            format = "^" + format;
        }
        return format;
    }

    private void visitFile() {
        if (this.isRegularExpression) {
            this.checkRegularExpression(this.context.getFileContent());
        } else if (!FileHeaderCheck.matches(this.expectedLines, this.context.getFileLines())) {
            this.addIssueOnFile(MESSAGE);
        }
    }

    private void checkRegularExpression(String fileContent) {
        Matcher matcher = this.searchPattern.matcher(fileContent);
        if (!matcher.find() || matcher.start() != 0) {
            this.addIssueOnFile(MESSAGE);
        }
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (int i = 0; i < expectedLines.length; ++i) {
                String line = it.next();
                if (line.equals(expectedLines[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

