/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3400")
public class ConstantMethodCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        ExpressionTree returnedExpression;
        StatementTree uniqueStatement;
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        BlockTree body = methodTree.block();
        if (!methodTree.modifiers().annotations().isEmpty() || ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.DEFAULT)) {
            return;
        }
        if (BooleanUtils.isFalse((Boolean)methodTree.isOverriding()) && body != null && body.body().size() == 1 && (uniqueStatement = (StatementTree)body.body().get(0)).is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) && ConstantMethodCheck.isConstant(returnedExpression = ((ReturnStatementTree)uniqueStatement).expression())) {
            this.reportIssue((Tree)returnedExpression, "Remove this method and declare a constant for this value.");
        }
    }

    private static boolean isConstant(@Nullable ExpressionTree returnedExpression) {
        return returnedExpression != null && returnedExpression.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL});
    }
}

