/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3658")
public class AssertionFailInCatchBlockCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Lists.newArrayList((Object[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("org.junit.Assert").name("fail").withAnyParameters(), MethodMatcher.create().typeDefinition("junit.framework.Assert").name(NameCriteria.startsWith((String)"fail")).withAnyParameters(), MethodMatcher.create().typeDefinition("org.fest.assertions.Fail").name(NameCriteria.startsWith((String)"fail")).withAnyParameters()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (AssertionFailInCatchBlockCheck.isInCatch((Tree)mit)) {
            this.reportIssue((Tree)mit, "Remove this failure assertion and simply add the exception type to the method signature.");
        }
    }

    private static boolean isInCatch(Tree tree) {
        Tree parent = tree.parent();
        return parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD}) && (parent.is(new Tree.Kind[]{Tree.Kind.CATCH}) || AssertionFailInCatchBlockCheck.isInCatch(parent));
    }
}

