/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractPrintfChecker
extends AbstractMethodDetection {
    private static final Pattern PRINTF_PARAM_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final String FORMAT_METHOD_NAME = "format";
    protected static final MethodMatcher MESSAGE_FORMAT = MethodMatcher.create().typeDefinition("java.text.MessageFormat").name("format").withAnyParameters();
    protected static final Pattern MESSAGE_FORMAT_PATTERN = Pattern.compile("\\{(?<index>\\d+)(?<type>,\\w+)?(?<style>,[^}]*)?\\}");

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.lang.String").name(FORMAT_METHOD_NAME).withAnyParameters(), (Object)MethodMatcher.create().typeDefinition("java.util.Formatter").name(FORMAT_METHOD_NAME).withAnyParameters(), (Object)MethodMatcher.create().typeDefinition("java.io.PrintStream").name(FORMAT_METHOD_NAME).withAnyParameters(), (Object)MethodMatcher.create().typeDefinition("java.io.PrintStream").name("printf").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition("java.io.PrintWriter").name(FORMAT_METHOD_NAME).withAnyParameters(), (Object)MethodMatcher.create().typeDefinition("java.io.PrintWriter").name("printf").withAnyParameters(), (Object)MESSAGE_FORMAT);
    }

    protected abstract void handlePrintfFormat(MethodInvocationTree var1, String var2, List<ExpressionTree> var3);

    protected abstract void handleMessageFormat(MethodInvocationTree var1, String var2, List<ExpressionTree> var3);

    protected static boolean isNewArrayWithInitializers(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY}) && ((NewArrayTree)expression).openBraceToken() != null;
    }

    protected static String cleanupDoubleQuote(String formatString) {
        return formatString.replaceAll("''", "");
    }

    protected static Set<Integer> getMessageFormatIndexes(String formatString) {
        Matcher matcher = MESSAGE_FORMAT_PATTERN.matcher(formatString);
        HashSet<Integer> result = new HashSet<Integer>();
        while (matcher.find()) {
            if (!AbstractPrintfChecker.isMessageFormatPattern(formatString, matcher.start())) continue;
            result.add(Integer.parseInt(matcher.group("index")));
        }
        return result;
    }

    private static boolean isMessageFormatPattern(String formatString, int start) {
        return start == 0 || formatString.charAt(start - 1) != '\'' || StringUtils.countMatches((String)formatString.substring(0, start), (String)"'") % 2 == 0;
    }

    protected List<String> getParameters(String formatString, MethodInvocationTree mit) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcher = PRINTF_PARAM_PATTERN.matcher(formatString);
        while (matcher.find()) {
            if (AbstractPrintfChecker.firstArgumentIsLT(params, matcher.group(2))) {
                this.reportMissingPrevious(mit);
                continue;
            }
            StringBuilder param = new StringBuilder();
            for (int groupIndex : new int[]{1, 2, 5, 6}) {
                if (matcher.group(groupIndex) == null) continue;
                param.append(matcher.group(groupIndex));
            }
            String specifier = param.toString();
            if ("%".equals(specifier)) continue;
            params.add(specifier);
        }
        return params;
    }

    protected void reportMissingPrevious(MethodInvocationTree mit) {
    }

    protected static Integer getIndex(String param) {
        return Integer.valueOf(param.substring(0, param.indexOf(36)));
    }

    protected static void cleanupLineSeparator(List<String> params) {
        Iterator<String> iter = params.iterator();
        while (iter.hasNext()) {
            String param = iter.next();
            if (!"n".equals(param)) continue;
            iter.remove();
        }
    }

    protected static Set<Integer> argIndexes(List<String> params) {
        int index = 0;
        HashSet<Integer> result = new HashSet<Integer>();
        for (String rawParam : params) {
            if (rawParam.contains("$")) {
                result.add(AbstractPrintfChecker.getIndex(rawParam));
                continue;
            }
            if (rawParam.charAt(0) == '<') continue;
            result.add(++index);
        }
        return result;
    }

    private static boolean firstArgumentIsLT(List<String> params, @Nullable String group) {
        return params.isEmpty() && group != null && group.length() > 0 && group.charAt(0) == '<';
    }
}

