/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.config.Credentials;
import org.redisson.config.CredentialsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.authentication.core.Token;
import redis.clients.authentication.core.TokenListener;
import redis.clients.authentication.core.TokenManager;

public class EntraIdCredentialsResolver
implements CredentialsResolver {
    private static final Logger log = LoggerFactory.getLogger(EntraIdCredentialsResolver.class);
    final TokenManager tokenManager;
    volatile CompletableFuture<Credentials> future = new CompletableFuture();
    volatile CompletableFuture<Void> renewalFuture = new CompletableFuture();

    public EntraIdCredentialsResolver(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
        TokenListener listener = new TokenListener(){

            public void onTokenRenewed(Token token) {
                if (!EntraIdCredentialsResolver.this.future.isDone()) {
                    EntraIdCredentialsResolver.this.future.complete(new Credentials(token.getUser(), token.getValue()));
                } else {
                    EntraIdCredentialsResolver.this.future = CompletableFuture.completedFuture(new Credentials(token.getUser(), token.getValue()));
                    CompletableFuture<Void> oldFuture = EntraIdCredentialsResolver.this.renewalFuture;
                    EntraIdCredentialsResolver.this.renewalFuture = new CompletableFuture();
                    oldFuture.complete(null);
                }
            }

            public void onError(Exception e) {
                log.error("Unable to renew token", (Throwable)e);
            }
        };
        try {
            tokenManager.start(listener, false);
        }
        catch (Exception e) {
            CompletableFuture cf = new CompletableFuture();
            cf.completeExceptionally(e);
            this.future = cf;
            tokenManager.stop();
            throw new IllegalStateException("Unable to start", e);
        }
    }

    @Override
    public CompletionStage<Credentials> resolve(InetSocketAddress address) {
        return this.future;
    }

    @Override
    public CompletionStage<Void> nextRenewal() {
        return this.renewalFuture;
    }
}

