/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonShardedTopic;
import org.redisson.RedissonTopic;
import org.redisson.api.RFuture;
import org.redisson.api.RSemaphore;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.StringCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.AdderEntry;
import org.redisson.misc.CompletableFutureWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedissonBaseAdder<T extends Number>
extends RedissonExpirable {
    private static final Logger log = LoggerFactory.getLogger(RedissonBaseAdder.class);
    private static final String CLEAR_MSG = "0";
    private static final String SUM_MSG = "1";
    private final RedissonClient redisson;
    private final RTopic topic;
    private final int listenerId;

    public RedissonBaseAdder(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name);
        this.topic = this.getSubscribeService().isShardingSupported() ? RedissonShardedTopic.createRaw(StringCodec.INSTANCE, commandExecutor, RedissonBaseAdder.suffixName(this.getRawName(), "adder-topic")) : RedissonTopic.createRaw(StringCodec.INSTANCE, commandExecutor, RedissonBaseAdder.suffixName(this.getRawName(), "adder-topic"));
        this.redisson = redisson;
        AdderEntry entry = this.getServiceManager().getAddersUsage().computeIfAbsent(name, r -> new AdderEntry());
        entry.getUsage().incrementAndGet();
        this.listenerId = this.topic.addListener(String.class, (channel, msg) -> {
            String[] parts = msg.split(":");
            String id = parts[1];
            entry.getIds().add(id);
            if (parts[0].equals(SUM_MSG)) {
                RFuture<Number> addAndGetFuture = this.addAndGetAsync(id);
                addAndGetFuture.whenComplete((res, e) -> {
                    if (e != null) {
                        log.error("Can't increase sum", e);
                        return;
                    }
                    this.release(id, entry);
                });
            }
            if (parts[0].equals(CLEAR_MSG)) {
                this.doReset();
                this.release(id, entry);
            }
        });
    }

    private void release(String id, AdderEntry entry) {
        AtomicInteger counter = this.getServiceManager().getAddersCounter().computeIfAbsent(id, r -> new AtomicInteger());
        if (counter.incrementAndGet() == entry.getUsage().get() || entry.getUsage().get() == 0) {
            this.getServiceManager().getAddersCounter().remove(id);
            entry.getIds().remove(id);
            RSemaphore semaphore = this.getSemaphore(id);
            semaphore.releaseAsync().whenComplete((r, ex) -> {
                if (ex != null) {
                    log.error("Can't release semaphore", ex);
                }
            });
        }
    }

    protected abstract void doReset();

    public void reset() {
        this.get(this.resetAsync());
    }

    public void reset(long timeout, TimeUnit timeUnit) {
        this.get(this.resetAsync(timeout, timeUnit));
    }

    public RFuture<T> sumAsync() {
        String id = this.getServiceManager().generateId();
        RSemaphore semaphore = this.getSemaphore(id);
        RFuture<Long> future = this.topic.publishAsync("1:" + id);
        CompletionStage f = future.thenCompose(r -> semaphore.acquireAsync(r.intValue())).thenCompose(r -> this.getAndDeleteAsync(id)).thenCompose(r -> semaphore.deleteAsync().thenApply(res -> r));
        return new CompletableFutureWrapper(f);
    }

    private RSemaphore getSemaphore(String id) {
        return this.redisson.getSemaphore(RedissonBaseAdder.suffixName(this.getRawName(), id + ":semaphore"));
    }

    protected String getCounterName(String id) {
        return RedissonBaseAdder.suffixName(this.getRawName(), id + ":counter");
    }

    public RFuture<T> sumAsync(long timeout, TimeUnit timeUnit) {
        String id = this.getServiceManager().generateId();
        RSemaphore semaphore = this.getSemaphore(id);
        RFuture<Long> future = this.topic.publishAsync("1:" + id);
        CompletionStage f = future.thenCompose(r -> this.tryAcquire(semaphore, timeout, timeUnit, r.intValue())).thenCompose(r -> this.getAndDeleteAsync(id)).thenCompose(r -> semaphore.deleteAsync().thenApply(res -> r));
        return new CompletableFutureWrapper(f);
    }

    protected CompletionStage<Void> tryAcquire(RSemaphore semaphore, long timeout, TimeUnit timeUnit, int value) {
        return semaphore.tryAcquireAsync(value, timeout, timeUnit).handle((res, e) -> {
            if (e != null) {
                throw new CompletionException((Throwable)e);
            }
            if (res.booleanValue()) {
                return null;
            }
            throw new CompletionException(new TimeoutException());
        });
    }

    public RFuture<Void> resetAsync() {
        String id = this.getServiceManager().generateId();
        RSemaphore semaphore = this.getSemaphore(id);
        RFuture<Long> future = this.topic.publishAsync("0:" + id);
        CompletionStage f = future.thenCompose(r -> semaphore.acquireAsync(r.intValue())).thenCompose(r -> semaphore.deleteAsync().thenApply(res -> null));
        return new CompletableFutureWrapper<Void>(f);
    }

    public RFuture<Void> resetAsync(long timeout, TimeUnit timeUnit) {
        String id = this.getServiceManager().generateId();
        RSemaphore semaphore = this.getSemaphore(id);
        RFuture<Long> future = this.topic.publishAsync("0:" + id);
        CompletionStage f = future.thenCompose(r -> this.tryAcquire(semaphore, timeout, timeUnit, r.intValue())).thenCompose(r -> semaphore.deleteAsync().thenApply(res -> null));
        return new CompletableFutureWrapper<Void>(f);
    }

    public void destroy() {
        this.topic.removeListener(this.listenerId);
        AdderEntry entry = this.getServiceManager().getAddersUsage().get(this.name);
        if (entry != null && entry.getUsage().decrementAndGet() == 0) {
            for (String id : entry.getIds()) {
                this.release(id, entry);
            }
            this.getServiceManager().getAddersUsage().remove(this.name, entry);
        }
    }

    protected abstract RFuture<T> addAndGetAsync(String var1);

    protected abstract RFuture<T> getAndDeleteAsync(String var1);
}

