/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.redisson.Redisson;
import org.redisson.jcache.JCache;
import org.redisson.jcache.bean.EmptyStatisticsMXBean;
import org.redisson.jcache.bean.JCacheManagementMXBean;
import org.redisson.jcache.bean.JCacheStatisticsMXBean;
import org.redisson.jcache.configuration.JCacheConfiguration;
import org.redisson.jcache.configuration.RedissonConfiguration;

public class JCacheManager
implements CacheManager {
    private static final EmptyStatisticsMXBean EMPTY_INSTANCE = new EmptyStatisticsMXBean();
    private static final MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private final ClassLoader classLoader;
    private final CachingProvider cacheProvider;
    private final Properties properties;
    private final URI uri;
    private final ConcurrentMap<String, Cache<?, ?>> caches = new ConcurrentHashMap();
    private final ConcurrentMap<Cache<?, ?>, JCacheStatisticsMXBean> statBeans = new ConcurrentHashMap();
    private final ConcurrentMap<Cache<?, ?>, JCacheManagementMXBean> managementBeans = new ConcurrentHashMap();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Redisson redisson;

    JCacheManager(Redisson redisson, ClassLoader classLoader, CachingProvider cacheProvider, Properties properties, URI uri) {
        this.classLoader = classLoader;
        this.cacheProvider = cacheProvider;
        this.properties = properties;
        this.uri = uri;
        this.redisson = redisson;
    }

    public CachingProvider getCachingProvider() {
        return this.cacheProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void checkNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException();
        }
    }

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        JCacheConfiguration cfg;
        JCache cache;
        Cache oldCache;
        this.checkNotClosed();
        Redisson cacheRedisson = this.redisson;
        if (cacheName == null) {
            throw new NullPointerException();
        }
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (cacheRedisson == null && !(configuration instanceof RedissonConfiguration)) {
            throw new IllegalStateException("Default configuration hasn't been specified!");
        }
        boolean hasOwnRedisson = false;
        if (configuration instanceof RedissonConfiguration) {
            RedissonConfiguration rc = (RedissonConfiguration)configuration;
            if (rc.getConfig() != null) {
                cacheRedisson = (Redisson)Redisson.create(rc.getConfig());
                hasOwnRedisson = true;
            } else {
                cacheRedisson = (Redisson)rc.getRedisson();
            }
        }
        if ((oldCache = (Cache)this.caches.putIfAbsent(cacheName, cache = new JCache(this, cacheRedisson, cacheName, cfg = new JCacheConfiguration(configuration), hasOwnRedisson))) != null) {
            throw new CacheException("Cache " + cacheName + " already exists");
        }
        if (cfg.isStatisticsEnabled()) {
            this.enableStatistics(cacheName, true);
        }
        if (cfg.isManagementEnabled()) {
            this.enableManagement(cacheName, true);
        }
        return cache;
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        if (keyType == null) {
            throw new NullPointerException();
        }
        if (valueType == null) {
            throw new NullPointerException();
        }
        Cache cache = (Cache)this.caches.get(cacheName);
        if (cache == null) {
            return null;
        }
        if (!keyType.isAssignableFrom(((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getKeyType())) {
            throw new ClassCastException("Wrong type of key for " + cacheName);
        }
        if (!valueType.isAssignableFrom(((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getValueType())) {
            throw new ClassCastException("Wrong type of value for " + cacheName);
        }
        return cache;
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.checkNotClosed();
        Cache<Object, Object> cache = this.getCache(cacheName, Object.class, Object.class);
        if (cache != null) {
            if (!((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getKeyType().isAssignableFrom(Object.class)) {
                throw new IllegalArgumentException("Wrong type of key for " + cacheName);
            }
            if (!((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getValueType().isAssignableFrom(Object.class)) {
                throw new IllegalArgumentException("Wrong type of value for " + cacheName);
            }
        }
        return cache;
    }

    public Iterable<String> getCacheNames() {
        return Collections.unmodifiableSet(new HashSet(this.caches.keySet()));
    }

    public void destroyCache(String cacheName) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Cache cache = (Cache)this.caches.get(cacheName);
        if (cache != null) {
            cache.clear();
            cache.close();
        }
    }

    public void closeCache(JCache<?, ?> cache) {
        this.caches.remove(cache.getRawName());
        this.unregisterStatisticsBean(cache);
        this.unregisterManagementBean(cache);
    }

    /*
     * Unable to fully structure code
     */
    public void enableManagement(String cacheName, boolean enabled) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        cache = (Cache)this.caches.get(cacheName);
        if (cache == null) {
            throw new NullPointerException();
        }
        if (enabled) {
            statBean = (JCacheManagementMXBean)this.managementBeans.get(cache);
            if (statBean == null && (oldBean = this.managementBeans.putIfAbsent(cache, statBean = new JCacheManagementMXBean(cache))) != null) {
                statBean = oldBean;
            }
            try {
                objectName = this.queryNames("Configuration", cache);
                if (!JCacheManager.MBEAN_SERVER.queryNames(objectName, null).isEmpty()) ** GOTO lbl26
                JCacheManager.MBEAN_SERVER.registerMBean(statBean, objectName);
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException((Throwable)e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new CacheException((Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                throw new CacheException((Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                throw new CacheException((Throwable)e);
            }
        } else {
            this.unregisterManagementBean(cache);
        }
lbl26:
        // 3 sources

        ((JCacheConfiguration)cache.getConfiguration(JCacheConfiguration.class)).setManagementEnabled(enabled);
    }

    private ObjectName queryNames(String baseName, Cache<?, ?> cache) throws MalformedObjectNameException {
        String name = this.getName(baseName, cache);
        return new ObjectName(name);
    }

    private void unregisterManagementBean(Cache<?, ?> cache) {
        JCacheManagementMXBean statBean = (JCacheManagementMXBean)this.managementBeans.remove(cache);
        if (statBean != null) {
            try {
                ObjectName name = this.queryNames("Configuration", cache);
                for (ObjectName objectName : MBEAN_SERVER.queryNames(name, null)) {
                    MBEAN_SERVER.unregisterMBean(objectName);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException((Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                throw new CacheException((Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    public JCacheStatisticsMXBean getStatBean(JCache<?, ?> cache) {
        JCacheStatisticsMXBean bean = (JCacheStatisticsMXBean)this.statBeans.get(cache);
        if (bean != null) {
            return bean;
        }
        return EMPTY_INSTANCE;
    }

    private String getName(String name, Cache<?, ?> cache) {
        return "javax.cache:type=Cache" + name + ",CacheManager=" + this.getURI().toString().replaceAll(",|:|=|\n", ".") + ",Cache=" + cache.getName().replaceAll(",|:|=|\n", ".");
    }

    /*
     * Unable to fully structure code
     */
    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        cache = (Cache)this.caches.get(cacheName);
        if (cache == null) {
            throw new NullPointerException();
        }
        if (enabled) {
            statBean = (JCacheStatisticsMXBean)this.statBeans.get(cache);
            if (statBean == null && (oldBean = this.statBeans.putIfAbsent(cache, statBean = new JCacheStatisticsMXBean())) != null) {
                statBean = oldBean;
            }
            try {
                objectName = this.queryNames("Statistics", cache);
                if (JCacheManager.MBEAN_SERVER.isRegistered(objectName)) ** GOTO lbl26
                JCacheManager.MBEAN_SERVER.registerMBean(statBean, objectName);
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException((Throwable)e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new CacheException((Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                throw new CacheException((Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                throw new CacheException((Throwable)e);
            }
        } else {
            this.unregisterStatisticsBean(cache);
        }
lbl26:
        // 3 sources

        ((JCacheConfiguration)cache.getConfiguration(JCacheConfiguration.class)).setStatisticsEnabled(enabled);
    }

    private void unregisterStatisticsBean(Cache<?, ?> cache) {
        JCacheStatisticsMXBean statBean = (JCacheStatisticsMXBean)this.statBeans.remove(cache);
        if (statBean != null) {
            try {
                ObjectName name = this.queryNames("Statistics", cache);
                for (ObjectName objectName : MBEAN_SERVER.queryNames(name, null)) {
                    MBEAN_SERVER.unregisterMBean(objectName);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException((Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                throw new CacheException((Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.cacheProvider != null) {
                this.cacheProvider.close(this.uri, this.classLoader);
            }
            for (Cache cache : this.caches.values()) {
                try {
                    cache.close();
                }
                catch (Exception exception) {}
            }
            if (this.redisson != null) {
                this.redisson.shutdown();
            }
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException();
    }
}

