/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBufUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.pubsub.SemaphorePubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonPermitExpirableSemaphore
extends RedissonExpirable
implements RPermitExpirableSemaphore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedissonPermitExpirableSemaphore.class);
    private final String channelName;
    private final SemaphorePubSub semaphorePubSub;
    private final String timeoutName = RedissonPermitExpirableSemaphore.suffixName(this.getRawName(), "timeout");
    private final long nonExpirableTimeout = 922337203685477L;

    public RedissonPermitExpirableSemaphore(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.semaphorePubSub = commandExecutor.getConnectionManager().getSubscribeService().getSemaphorePubSub();
        this.channelName = RedissonPermitExpirableSemaphore.prefixName("redisson_sc", this.getRawName());
    }

    @Override
    public String acquire() throws InterruptedException {
        return this.acquire(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public List<String> acquire(int permits) throws InterruptedException {
        return this.acquire(permits, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String acquire(long leaseTime, TimeUnit timeUnit) throws InterruptedException {
        List<String> ids = this.acquire(1, leaseTime, timeUnit);
        return RedissonPermitExpirableSemaphore.getFirstOrNull(ids);
    }

    @Override
    public List<String> acquire(int permits, long leaseTime, TimeUnit timeUnit) throws InterruptedException {
        List<String> ids = this.tryAcquire(permits, leaseTime, timeUnit);
        if (!ids.isEmpty() && !RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
            return ids;
        }
        CompletableFuture<RedissonLockEntry> future = this.subscribe();
        this.semaphorePubSub.timeout((CompletableFuture)future);
        RedissonLockEntry entry = this.commandExecutor.getInterrupted(future);
        try {
            while (true) {
                Long nearestTimeout;
                if ((ids = this.tryAcquire(permits, leaseTime, timeUnit)).isEmpty()) {
                    nearestTimeout = null;
                } else if (RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
                    nearestTimeout = Long.parseLong(ids.get(0).substring(1)) - System.currentTimeMillis();
                } else {
                    List<String> list = ids;
                    return list;
                }
                if (nearestTimeout != null) {
                    entry.getLatch().tryAcquire(permits, nearestTimeout, TimeUnit.MILLISECONDS);
                    continue;
                }
                entry.getLatch().acquire(permits);
            }
        }
        finally {
            this.unsubscribe(entry);
        }
    }

    @Override
    public RFuture<String> acquireAsync() {
        CompletionStage<String> future = this.acquireAsync(1).thenApply(RedissonPermitExpirableSemaphore::getFirstOrNull);
        return new CompletableFutureWrapper<String>(future);
    }

    @Override
    public RFuture<List<String>> acquireAsync(int permits) {
        return this.acquireAsync(permits, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public RFuture<String> acquireAsync(long leaseTime, TimeUnit timeUnit) {
        CompletionStage<String> future = this.acquireAsync(1, leaseTime, timeUnit).thenApply(RedissonPermitExpirableSemaphore::getFirstOrNull);
        return new CompletableFutureWrapper<String>(future);
    }

    @Override
    public RFuture<List<String>> acquireAsync(int permits, long leaseTime, TimeUnit timeUnit) {
        long timeoutDate = this.calcTimeout(leaseTime, timeUnit);
        RFuture<List<String>> tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate);
        CompletionStage f = tryAcquireFuture.thenCompose(ids -> {
            if (!ids.isEmpty() && !RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
                return CompletableFuture.completedFuture(ids);
            }
            CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            this.semaphorePubSub.timeout((CompletableFuture)subscribeFuture);
            return subscribeFuture.thenCompose(res -> this.acquireAsync(permits, (RedissonLockEntry)res, leaseTime, timeUnit));
        });
        f.whenComplete((r, e) -> {
            if (f.toCompletableFuture().isCancelled()) {
                tryAcquireFuture.whenComplete((ids, ex) -> {
                    if (!ids.isEmpty() && !RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
                        this.releaseAsync((List<String>)ids);
                    }
                });
            }
        });
        return new CompletableFutureWrapper<List<String>>(f);
    }

    private void tryAcquireAsync(final AtomicLong time, final int permits, final RedissonLockEntry entry, final CompletableFuture<List<String>> result, final long leaseTime, final TimeUnit timeUnit) {
        if (result.isDone()) {
            this.unsubscribe(entry);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(entry);
            result.complete(Collections.emptyList());
            return;
        }
        long timeoutDate = this.calcTimeout(leaseTime, timeUnit);
        long curr = System.currentTimeMillis();
        RFuture<List<String>> tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate);
        tryAcquireFuture.whenComplete((ids, e) -> {
            Long nearestTimeout;
            if (e != null) {
                this.unsubscribe(entry);
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (ids.isEmpty()) {
                nearestTimeout = null;
            } else if (RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
                nearestTimeout = Long.parseLong(((String)ids.get(0)).substring(1)) - System.currentTimeMillis();
            } else {
                this.unsubscribe(entry);
                if (!result.complete((List<String>)ids)) {
                    this.releaseAsync((List<String>)ids);
                }
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(entry);
                result.complete(Collections.emptyList());
                return;
            }
            final long current = System.currentTimeMillis();
            if (entry.getLatch().tryAcquire()) {
                this.tryAcquireAsync(time, permits, entry, result, leaseTime, timeUnit);
            } else {
                final AtomicReference<Timeout> waitTimeoutFutureRef = new AtomicReference<Timeout>();
                final Timeout scheduledFuture = nearestTimeout != null ? this.getServiceManager().newTimeout(new TimerTask(){

                    public void run(Timeout timeout) throws Exception {
                        if (waitTimeoutFutureRef.get() != null && !((Timeout)waitTimeoutFutureRef.get()).cancel()) {
                            return;
                        }
                        long elapsed = System.currentTimeMillis() - current;
                        time.addAndGet(-elapsed);
                        RedissonPermitExpirableSemaphore.this.tryAcquireAsync(time, permits, entry, result, leaseTime, timeUnit);
                    }
                }, nearestTimeout, TimeUnit.MILLISECONDS) : null;
                final Runnable listener = () -> {
                    if (waitTimeoutFutureRef.get() != null && !((Timeout)waitTimeoutFutureRef.get()).cancel()) {
                        entry.getLatch().release();
                        return;
                    }
                    if (scheduledFuture != null && !scheduledFuture.cancel()) {
                        entry.getLatch().release();
                        return;
                    }
                    long elapsed = System.currentTimeMillis() - current;
                    time.addAndGet(-elapsed);
                    this.tryAcquireAsync(time, permits, entry, result, leaseTime, timeUnit);
                };
                entry.addListener(listener);
                long t = time.get();
                Timeout waitTimeoutFuture = this.getServiceManager().newTimeout(new TimerTask(){

                    public void run(Timeout timeout) throws Exception {
                        if (scheduledFuture != null && !scheduledFuture.cancel()) {
                            return;
                        }
                        if (entry.removeListener(listener)) {
                            long elapsed = System.currentTimeMillis() - current;
                            time.addAndGet(-elapsed);
                            RedissonPermitExpirableSemaphore.this.tryAcquireAsync(time, permits, entry, result, leaseTime, timeUnit);
                        }
                    }
                }, t, TimeUnit.MILLISECONDS);
                waitTimeoutFutureRef.set(waitTimeoutFuture);
            }
        });
    }

    private CompletableFuture<List<String>> acquireAsync(int permits, RedissonLockEntry entry, long leaseTime, TimeUnit timeUnit) {
        long timeoutDate = this.calcTimeout(leaseTime, timeUnit);
        CompletableFuture tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate).toCompletableFuture();
        return ((CompletableFuture)tryAcquireFuture.whenComplete((p, e) -> {
            if (e != null) {
                this.unsubscribe(entry);
            }
        })).thenCompose(ids -> {
            Long nearestTimeout;
            if (ids.isEmpty()) {
                nearestTimeout = null;
            } else if (RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
                nearestTimeout = Long.parseLong(((String)ids.get(0)).substring(1)) - System.currentTimeMillis();
            } else {
                this.unsubscribe(entry);
                return CompletableFuture.completedFuture(ids);
            }
            if (entry.getLatch().tryAcquire(permits)) {
                return this.acquireAsync(permits, entry, leaseTime, timeUnit);
            }
            CompletableFuture res = new CompletableFuture();
            Timeout scheduledFuture = nearestTimeout != null ? this.getServiceManager().newTimeout(timeout -> {
                CompletableFuture<List<String>> r = this.acquireAsync(permits, entry, leaseTime, timeUnit);
                this.commandExecutor.transfer(r, res);
            }, nearestTimeout, TimeUnit.MILLISECONDS) : null;
            Runnable listener = () -> {
                if (scheduledFuture != null && !scheduledFuture.cancel()) {
                    entry.getLatch().release();
                    return;
                }
                CompletableFuture<List<String>> r = this.acquireAsync(permits, entry, leaseTime, timeUnit);
                this.commandExecutor.transfer(r, res);
            };
            entry.addListener(listener);
            return res;
        });
    }

    @Override
    public String tryAcquire() {
        List<String> ids = this.tryAcquire(1);
        return RedissonPermitExpirableSemaphore.getFirstOrNull(ids);
    }

    @Override
    public List<String> tryAcquire(int permits) {
        List<String> ids = this.tryAcquire(permits, -1L, TimeUnit.MILLISECONDS);
        if (RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
            return Collections.emptyList();
        }
        return ids;
    }

    private List<String> tryAcquire(int permits, long leaseTime, TimeUnit timeUnit) {
        long timeoutDate = this.calcTimeout(leaseTime, timeUnit);
        return this.get(this.tryAcquireAsync(permits, timeoutDate));
    }

    private long calcTimeout(long leaseTime, TimeUnit timeUnit) {
        if (leaseTime != -1L) {
            return System.currentTimeMillis() + timeUnit.toMillis(leaseTime);
        }
        return 922337203685477L;
    }

    @Override
    public RFuture<String> tryAcquireAsync() {
        CompletionStage<String> future = this.tryAcquireAsync(1).thenApply(RedissonPermitExpirableSemaphore::getFirstOrNull);
        return new CompletableFutureWrapper<String>(future);
    }

    @Override
    public RFuture<List<String>> tryAcquireAsync(int permits) {
        CompletionStage future = this.tryAcquireAsync(permits, 922337203685477L).toCompletableFuture().thenApply(ids -> {
            if (RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
                return null;
            }
            return ids;
        });
        ((CompletableFuture)future).whenComplete((arg_0, arg_1) -> this.lambda$tryAcquireAsync$11((CompletableFuture)future, arg_0, arg_1));
        return new CompletableFutureWrapper<List<String>>((CompletableFuture<List<String>>)future);
    }

    private RFuture<List<String>> tryAcquireAsync(int permits, long timeoutDate) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        ArrayList<String> ids = new ArrayList<String>(permits);
        for (int i = 0; i < permits; ++i) {
            ids.add(this.getServiceManager().generateId());
        }
        return this.getServiceManager().execute(() -> {
            RFuture<List<String>> future = this.tryAcquireAsync(ids, timeoutDate);
            return this.commandExecutor.handleNoSync(future, () -> this.releaseAsync(ids));
        });
    }

    private RFuture<List<String>> tryAcquireAsync(List<String> ids, long timeoutDate) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(ids.size());
        params.add(timeoutDate);
        params.add(System.currentTimeMillis());
        params.add(922337203685477L);
        params.add(this.getSubscribeService().getPublishCommand());
        for (String permitId : ids) {
            params.add(ByteBufUtil.decodeHexDump((CharSequence)permitId));
        }
        CompletionStage<List> future = this.commandExecutor.syncedEval(this.getRawName(), ByteArrayCodec.INSTANCE, RedisCommands.EVAL_STRING, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[3], 'limit', 0, ARGV[1]); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call(ARGV[5], KEYS[3], value); end;end; local value = redis.call('get', KEYS[1]); if (value ~= false and tonumber(value) >= tonumber(ARGV[1])) then redis.call('decrby', KEYS[1], ARGV[1]); for i = 6, #ARGV, 1 do redis.call('zadd', KEYS[2], ARGV[2], ARGV[i]); end; local ttl = redis.call('pttl', KEYS[1]); if ttl > 0 then redis.call('pexpire', KEYS[2], ttl); end; return 'OK'; end; local v = redis.call('zrange', KEYS[2], 0, 0, 'WITHSCORES'); if v[1] ~= nil and v[2] ~= ARGV[4] then return ':' .. tostring(v[2]); end return nil;", Arrays.asList(this.getRawName(), this.timeoutName, this.channelName), params.toArray()).thenApply(result -> {
            if (result == null) {
                return Collections.emptyList();
            }
            if (result.equals("OK")) {
                return ids;
            }
            return Collections.singletonList(result);
        });
        return new CompletableFutureWrapper<List<String>>(future);
    }

    @Override
    public RFuture<String> tryAcquireAsync(long waitTime, TimeUnit unit) {
        CompletionStage<String> future = this.tryAcquireAsync(1, waitTime, -1L, unit).thenApply(RedissonPermitExpirableSemaphore::getFirstOrNull);
        return new CompletableFutureWrapper<String>(future);
    }

    @Override
    public String tryAcquire(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        List<String> ids = this.tryAcquire(1, waitTime, leaseTime, unit);
        return RedissonPermitExpirableSemaphore.getFirstOrNull(ids);
    }

    @Override
    public RFuture<String> tryAcquireAsync(long waitTime, long leaseTime, TimeUnit unit) {
        CompletionStage<String> future = this.tryAcquireAsync(1, waitTime, leaseTime, unit).thenApply(RedissonPermitExpirableSemaphore::getFirstOrNull);
        return new CompletableFutureWrapper<String>(future);
    }

    @Override
    public List<String> tryAcquire(int permits, long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        RedissonLockEntry entry;
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        List<String> ids = this.tryAcquire(permits, leaseTime, unit);
        if (!ids.isEmpty() && !RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
            return ids;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            return Collections.emptyList();
        }
        current = System.currentTimeMillis();
        CompletableFuture<RedissonLockEntry> future = this.subscribe();
        try {
            entry = future.get(time, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        catch (TimeoutException e) {
            return Collections.emptyList();
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                List<String> e = Collections.emptyList();
                return e;
            }
            while (true) {
                Long nearestTimeout;
                current = System.currentTimeMillis();
                ids = this.tryAcquire(permits, leaseTime, unit);
                if (ids.isEmpty()) {
                    nearestTimeout = null;
                } else if (RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
                    nearestTimeout = Long.parseLong(ids.get(0).substring(1)) - System.currentTimeMillis();
                } else {
                    List<String> list = ids;
                    return list;
                }
                if ((time -= System.currentTimeMillis() - current) <= 0L) {
                    List<String> list = Collections.emptyList();
                    return list;
                }
                current = System.currentTimeMillis();
                if (nearestTimeout != null) {
                    entry.getLatch().tryAcquire(permits, Math.min(time, nearestTimeout), TimeUnit.MILLISECONDS);
                } else {
                    entry.getLatch().tryAcquire(permits, time, TimeUnit.MILLISECONDS);
                }
                long elapsed = System.currentTimeMillis() - current;
                if ((time -= elapsed) > 0L) continue;
                List<String> list = Collections.emptyList();
                return list;
            }
        }
        finally {
            this.unsubscribe(entry);
        }
    }

    @Override
    public RFuture<List<String>> tryAcquireAsync(int permits, long waitTime, long leaseTime, TimeUnit timeUnit) {
        final CompletableFuture result = new CompletableFuture();
        AtomicLong time = new AtomicLong(timeUnit.toMillis(waitTime));
        long curr = System.currentTimeMillis();
        long timeoutDate = this.calcTimeout(leaseTime, timeUnit);
        this.tryAcquireAsync(permits, timeoutDate).whenComplete((ids, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (!ids.isEmpty() && !RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
                if (!result.complete(ids)) {
                    this.releaseAsync((List<String>)ids);
                }
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                result.complete(Collections.emptyList());
                return;
            }
            long current = System.currentTimeMillis();
            AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
            final CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            subscribeFuture.whenComplete((r, ex) -> {
                if (ex != null) {
                    result.completeExceptionally((Throwable)ex);
                    return;
                }
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                this.tryAcquireAsync(time, permits, (RedissonLockEntry)r, result, leaseTime, timeUnit);
            });
            if (!subscribeFuture.isDone()) {
                Timeout scheduledFuture = this.getServiceManager().newTimeout(new TimerTask(){

                    public void run(Timeout timeout) throws Exception {
                        if (!subscribeFuture.isDone()) {
                            result.complete(Collections.emptyList());
                        }
                    }
                }, time.get(), TimeUnit.MILLISECONDS);
                futureRef.set(scheduledFuture);
            }
        });
        return new CompletableFutureWrapper<List<String>>(result);
    }

    private CompletableFuture<RedissonLockEntry> subscribe() {
        return this.semaphorePubSub.subscribe(this.getRawName(), this.channelName);
    }

    private void unsubscribe(RedissonLockEntry entry) {
        this.semaphorePubSub.unsubscribe(entry, this.getRawName(), this.channelName);
    }

    @Override
    public String tryAcquire(long waitTime, TimeUnit unit) throws InterruptedException {
        List<String> ids = this.tryAcquire(1, waitTime, -1L, unit);
        if (ids.isEmpty() || RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
            return null;
        }
        return ids.get(0);
    }

    @Override
    public void release(String permitId) {
        this.get(this.releaseAsync(permitId));
    }

    @Override
    public void release(List<String> permitsIds) {
        this.get(this.releaseAsync(permitsIds));
    }

    @Override
    public boolean tryRelease(String permitId) {
        return this.get(this.tryReleaseAsync(permitId));
    }

    @Override
    public int tryRelease(List<String> permitsIds) {
        return this.get(this.tryReleaseAsync(permitsIds));
    }

    @Override
    public RFuture<Boolean> tryReleaseAsync(String permitId) {
        if (permitId == null) {
            throw new IllegalArgumentException("permitId can't be null");
        }
        byte[] id = ByteBufUtil.decodeHexDump((CharSequence)permitId);
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local expire = redis.call('zscore', KEYS[3], ARGV[1]);local removed = redis.call('zrem', KEYS[3], ARGV[1]);if tonumber(removed) ~= 1 then return 0;end;local value = redis.call('incrby', KEYS[1], ARGV[2]); redis.call(ARGV[4], KEYS[2], value); if tonumber(expire) <= tonumber(ARGV[3]) then return 0;end;return 1;", Arrays.asList(this.getRawName(), this.channelName, this.timeoutName), id, 1, System.currentTimeMillis(), this.getSubscribeService().getPublishCommand());
    }

    @Override
    public RFuture<Integer> tryReleaseAsync(List<String> permitsIds) {
        if (permitsIds == null || permitsIds.isEmpty()) {
            throw new IllegalArgumentException("permitIds can't be null or empty");
        }
        ArrayList<Object> params = new ArrayList<Object>(permitsIds.size() + 3);
        params.add(permitsIds.size());
        params.add(System.currentTimeMillis());
        params.add(this.getSubscribeService().getPublishCommand());
        for (String permitId : permitsIds) {
            params.add(ByteBufUtil.decodeHexDump((CharSequence)permitId));
        }
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredIds = redis.call('zrangebyscore', KEYS[3], 0, ARGV[2], 'limit', 0, -1); if #expiredIds > 0 then redis.call('zrem', KEYS[3], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call(ARGV[3], KEYS[2], value); end; end; local keys = {}; for i = 4, #ARGV, 1 do table.insert(keys, ARGV[i]); end; local removed = redis.call('zrem', KEYS[3], unpack(keys)); if tonumber(removed) == 0 then return 0;end; redis.call('incrby', KEYS[1], removed); redis.call(ARGV[3], KEYS[2], removed); return removed;", Arrays.asList(this.getRawName(), this.channelName, this.timeoutName), params.toArray());
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.timeoutName);
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> copyAsync(List<Object> keys, int database, boolean replace) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.timeoutName);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.timeoutName);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.timeoutName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.timeoutName);
    }

    @Override
    public RFuture<Void> releaseAsync(String permitId) {
        CompletionStage<Void> f = this.tryReleaseAsync(permitId).handle((res, e) -> {
            if (e != null) {
                throw new CompletionException((Throwable)e);
            }
            if (res.booleanValue()) {
                return null;
            }
            throw new CompletionException(new IllegalArgumentException("Permit with id " + permitId + " has already been released or doesn't exist"));
        });
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Void> releaseAsync(List<String> permitsIds) {
        CompletionStage<Void> f = this.tryReleaseAsync(permitsIds).handle((res, e) -> {
            if (e != null) {
                throw new CompletionException((Throwable)e);
            }
            if (res.intValue() == permitsIds.size()) {
                return null;
            }
            throw new CompletionException(new IllegalArgumentException("Permits with ids " + permitsIds + " have already been released or don't exist"));
        });
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public int availablePermits() {
        return this.get(this.availablePermitsAsync());
    }

    @Override
    public int getPermits() {
        return this.get(this.getPermitsAsync());
    }

    @Override
    public int acquiredPermits() {
        return this.get(this.acquiredPermitsAsync());
    }

    @Override
    public RFuture<Integer> availablePermitsAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, -1); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call(ARGV[2], KEYS[3], value); end;return value; end; local ret = redis.call('get', KEYS[1]); return ret == false and 0 or ret;", Arrays.asList(this.getRawName(), this.timeoutName, this.channelName), System.currentTimeMillis(), this.getSubscribeService().getPublishCommand());
    }

    @Override
    public RFuture<Integer> getPermitsAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, -1); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call(ARGV[2], KEYS[3], value); end;end; local available = redis.call('get', KEYS[1]); if available == false then return 0 end;local acquired = redis.call('zcount', KEYS[2], 0, '+inf'); if acquired == false then return tonumber(available) end;return tonumber(available) + acquired;", Arrays.asList(this.getRawName(), this.timeoutName, this.channelName), System.currentTimeMillis(), this.getSubscribeService().getPublishCommand());
    }

    @Override
    public RFuture<Integer> acquiredPermitsAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, -1); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call(ARGV[2], KEYS[3], value); end;end; local acquired = redis.call('zcount', KEYS[2], 0, '+inf'); return acquired == false and 0 or acquired;", Arrays.asList(this.getRawName(), this.timeoutName, this.channelName), System.currentTimeMillis(), this.getSubscribeService().getPublishCommand());
    }

    @Override
    public boolean trySetPermits(int permits) {
        return this.get(this.trySetPermitsAsync(permits));
    }

    @Override
    public void setPermits(int permits) {
        this.get(this.setPermitsAsync(permits));
    }

    @Override
    public RFuture<Void> setPermitsAsync(int permits) {
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local available = redis.call('get', KEYS[1]); if (available == false) then redis.call('set', KEYS[1], ARGV[1]); redis.call(ARGV[2], KEYS[2], ARGV[1]); return;end;local acquired = redis.call('zcount', KEYS[3], 0, '+inf'); local maximum = (acquired == false and 0 or acquired) + tonumber(available); if (maximum == tonumber(ARGV[1])) then return;end;redis.call('incrby', KEYS[1], tonumber(ARGV[1]) - maximum); redis.call(ARGV[2], KEYS[2], ARGV[1]);", Arrays.asList(this.getRawName(), this.channelName, this.timeoutName), permits, this.getSubscribeService().getPublishCommand());
    }

    @Override
    public RFuture<Boolean> trySetPermitsAsync(int permits) {
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false) then redis.call('set', KEYS[1], ARGV[1]); redis.call(ARGV[2], KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getRawName(), this.channelName), permits, this.getSubscribeService().getPublishCommand());
    }

    @Override
    public void addPermits(int permits) {
        this.get(this.addPermitsAsync(permits));
    }

    @Override
    public RFuture<Void> addPermitsAsync(int permits) {
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('get', KEYS[1]); if (value == false) then value = 0;end;redis.call('set', KEYS[1], tonumber(value) + tonumber(ARGV[1])); if tonumber(ARGV[1]) > 0 then redis.call(ARGV[2], KEYS[2], ARGV[1]); end;", Arrays.asList(this.getRawName(), this.channelName), permits, this.getSubscribeService().getPublishCommand());
    }

    @Override
    public RFuture<Boolean> updateLeaseTimeAsync(String permitId, long leaseTime, TimeUnit unit) {
        long timeoutDate = this.calcTimeout(leaseTime, unit);
        byte[] id = ByteBufUtil.decodeHexDump((CharSequence)permitId);
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[3], 'limit', 0, -1); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call(ARGV[4], KEYS[3], value); end;end; local value = redis.call('zscore', KEYS[2], ARGV[1]); if (value ~= false) then redis.call('zadd', KEYS[2], ARGV[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getRawName(), this.timeoutName, this.channelName), id, timeoutDate, System.currentTimeMillis(), this.getSubscribeService().getPublishCommand());
    }

    @Override
    public boolean updateLeaseTime(String permitId, long leaseTime, TimeUnit unit) {
        return this.get(this.updateLeaseTimeAsync(permitId, leaseTime, unit));
    }

    private static boolean hasOnlyNearestTimeout(List<String> ids) {
        return ids.size() == 1 && ids.get(0).startsWith(":");
    }

    private static String getFirstOrNull(List<String> ids) {
        if (ids.isEmpty()) {
            return null;
        }
        return ids.get(0);
    }

    private /* synthetic */ void lambda$tryAcquireAsync$11(CompletableFuture future, List ids, Throwable e) {
        if (future.isCancelled() && !ids.isEmpty() && !RedissonPermitExpirableSemaphore.hasOnlyNearestTimeout(ids)) {
            this.releaseAsync(ids);
        }
    }
}

