/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.Kryo5Codec;

public class LZ4CodecV2
extends BaseCodec {
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufInputStream ios = new ByteBufInputStream(buf);
                FramedLZ4CompressorInputStream in = new FramedLZ4CompressorInputStream((InputStream)ios);
                out.writeBytes((InputStream)in, buf.readableBytes());
                in.close();
                Object object = LZ4CodecV2.this.innerCodec.getValueDecoder().decode(out, state);
                return object;
            }
            finally {
                out.release();
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf bytes = null;
            try {
                ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                FramedLZ4CompressorOutputStream compressor = new FramedLZ4CompressorOutputStream((OutputStream)baos);
                bytes = LZ4CodecV2.this.innerCodec.getValueEncoder().encode(in);
                bytes.getBytes(bytes.readerIndex(), (OutputStream)compressor, bytes.readableBytes());
                compressor.close();
                ByteBuf byteBuf = out;
                return byteBuf;
            }
            finally {
                if (bytes != null) {
                    bytes.release();
                }
            }
        }
    };

    public LZ4CodecV2() {
        this(new Kryo5Codec());
    }

    public LZ4CodecV2(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    public LZ4CodecV2(ClassLoader classLoader) {
        this(new Kryo5Codec(classLoader));
    }

    public LZ4CodecV2(ClassLoader classLoader, LZ4CodecV2 codec) throws ReflectiveOperationException {
        this(LZ4CodecV2.copy(classLoader, codec.innerCodec));
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

