/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.selector;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import reactor.event.selector.ObjectSelector;
import reactor.event.selector.Selector;

public class ExpressionSelector
extends ObjectSelector<Expression> {
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private final EvaluationContext evalCtx;

    public ExpressionSelector(Expression expr, EvaluationContext evalCtx) {
        super((Object)expr);
        this.evalCtx = evalCtx;
    }

    public boolean matches(Object key) {
        return (Boolean)((Expression)this.getObject()).getValue(this.evalCtx, key, Boolean.class);
    }

    public static Selector E(String expr) {
        return ExpressionSelector.expressionSelector(expr, (BeanFactory)null);
    }

    public static Selector expressionSelector(String expr) {
        return ExpressionSelector.expressionSelector(expr, (BeanFactory)null);
    }

    public static Selector expressionSelector(String expr, BeanFactory beanFactory) {
        StandardEvaluationContext evalCtx = new StandardEvaluationContext();
        if (null != beanFactory) {
            evalCtx.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        return ExpressionSelector.expressionSelector(expr, (EvaluationContext)evalCtx);
    }

    public static Selector expressionSelector(String expr, EvaluationContext evalCtx) {
        return new ExpressionSelector(SPEL_PARSER.parseExpression(expr), evalCtx);
    }
}

